/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.ui.editor.PersistentDVTNotification;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;

public class RefactoringConnectDiagramDVTNotification
extends PersistentDVTNotification {
    private StyledText styledText;
    private String displayString;
    private List<StyleRange> boldRegions = new ArrayList<StyleRange>();

    public RefactoringConnectDiagramDVTNotification(DDiagramEditor host, int style, String family, RefactoringConnectView view) {
        super(host, style, family);
        this.displayString = this.computeDiagramInfo(view);
    }

    @Override
    protected void createNotificationContents(Composite parent) {
        this.styledText = new StyledText(parent, 64);
        this.styledText.setText(this.displayString);
        this.styledText.setStyleRanges(this.boldRegions.toArray(new StyleRange[this.boldRegions.size()]));
        GridDataFactory.fillDefaults().grab(true, true).hint(100, -1).applyTo((Control)this.styledText);
    }

    private String computeDiagramInfo(RefactoringConnectView view) {
        StringBuilder result = new StringBuilder("Connecting ");
        String getfSrcPath = view.getSrcTxt();
        int boldStart = result.length();
        result.append(getfSrcPath);
        int boldLength = getfSrcPath.length();
        this.boldRegions.add(new StyleRange(boldStart, boldLength, null, null, 1));
        result.append(" to ");
        boldStart = result.length();
        String getfDstPath = view.getDstTxt();
        result.append(getfDstPath);
        boldLength = getfDstPath.length();
        this.boldRegions.add(new StyleRange(boldStart, boldLength, null, null, 1));
        return result.toString();
    }

    @Override
    protected void createButtons(Composite buttonsComposite) {
    }
}

