/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.ButtonFactory;
import ro.amiq.dvt.ui.editor.PersistentDVTNotification;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInfo;

public class RefactoringDiagramDVTNotification
extends PersistentDVTNotification {
    private DDiagramEditor editor;
    private StyledText styledText;
    private String displayString;
    private List<StyleRange> boldRegions = new ArrayList<StyleRange>();

    public RefactoringDiagramDVTNotification(DDiagramEditor host, int style, String family, PreviewDiagramInfo diagramPreview) {
        super(host, style, family);
        this.editor = host;
        this.displayString = this.computeDiagramInfo(diagramPreview);
    }

    @Override
    protected void createNotificationContents(Composite parent) {
        this.styledText = new StyledText(parent, 64);
        this.styledText.setText(this.displayString);
        this.styledText.setStyleRanges(this.boldRegions.toArray(new StyleRange[this.boldRegions.size()]));
        GridDataFactory.fillDefaults().grab(true, true).hint(100, -1).applyTo((Control)this.styledText);
    }

    @Override
    protected void createButtons(Composite buttonsComposite) {
        Button resume = ButtonFactory.INSTANCE.create(buttonsComposite, 0, 0.75);
        resume.setText("Resume");
        resume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringDiagramDVTNotification.this.destroy();
                RefactoringDiagramDVTNotification.this.editor.close();
                RfGUIReferencesUtils.switchBackToRenameAcrossHierarchyWizard(RfGUIReferencesUtils.getActiveRADHUserSettingsFromEditor(RefactoringDiagramDVTNotification.this.editor));
            }
        });
        Button cancel = ButtonFactory.INSTANCE.create(buttonsComposite, 0, 0.75);
        cancel.setText("Cancel");
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringDiagramDVTNotification.this.destroy();
                RefactoringDiagramDVTNotification.this.editor.close();
            }
        });
    }

    private String computeDiagramInfo(PreviewDiagramInfo diagramPreview) {
        StringBuilder result = new StringBuilder("Renaming ");
        String fieldType = "";
        String portName = "";
        IRfNamedElement renamedPortOrSignal = diagramPreview.getRenamedPortOrSignal();
        if (renamedPortOrSignal != null) {
            IRfSingleLangProject rfProject = renamedPortOrSignal.getRfProject();
            if (rfProject != null) {
                IProject project = rfProject.getProject();
                fieldType = RfSearchUtils.getPortOrSignalEnum(renamedPortOrSignal, project).toString();
            }
            portName = renamedPortOrSignal.getName();
        }
        result.append(fieldType).append(" ");
        List<IRfNamedElement> designInstances = diagramPreview.getInitialDesignInstance();
        result.append(RfSearchUtils.getDesignPath(designInstances));
        int boldStart = result.length();
        result.append(portName);
        int boldLength = portName.length();
        this.boldRegions.add(new StyleRange(boldStart, boldLength, null, null, 1));
        result.append(" to ");
        boldStart = result.length();
        result.append(diagramPreview.getNewName());
        boldLength = diagramPreview.getNewName().length();
        this.boldRegions.add(new StyleRange(boldStart, boldLength, null, null, 1));
        result.append(" ");
        int depth = diagramPreview.getRenameDepth();
        result.append(depth == 0 ? "" : String.valueOf(depth) + (depth == 1 ? " level " : " levels "));
        if (diagramPreview.isRenameInSubInstances() && diagramPreview.isRenameInParentInstances()) {
            result.append("up and down");
        } else if (diagramPreview.isRenameInSubInstances()) {
            result.append("down");
        } else {
            result.append("up");
        }
        result.append(" the design hierarchy");
        return result.toString();
    }
}

