/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.ButtonFactory;
import ro.amiq.dvt.ui.editor.PersistentDVTNotification;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;

public class SearchViewDVTNotification
extends PersistentDVTNotification {
    private static final String UPDATE_DB_AND_SEARCH_AGAIN = "Update DB and search again";
    private static final String DISMISS = "Dismiss";
    private BaseTextSearchQuery fQuery;

    public SearchViewDVTNotification(BaseTextSearchQuery searchQuery, BaseFileSearchPage host, int style, String family) {
        super(host, style, family);
        this.fQuery = searchQuery;
    }

    @Override
    protected void createButtons(Composite buttonsComposite) {
        Button resume = ButtonFactory.INSTANCE.create(buttonsComposite, 0, 0.75);
        resume.setText(UPDATE_DB_AND_SEARCH_AGAIN);
        resume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchViewDVTNotification.this.fQuery == null) {
                    return;
                }
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                try {
                    progressDialog.run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            RfGUIReferencesUtils.refreshProjectFiles((this).SearchViewDVTNotification.this.fQuery.getProject());
                            NewSearchUI.runQueryInBackground((ISearchQuery)(this).SearchViewDVTNotification.this.fQuery);
                        }
                    });
                }
                catch (Exception ex) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
                SearchViewDVTNotification.this.destroy();
            }
        });
        Button cancel = ButtonFactory.INSTANCE.create(buttonsComposite, 0, 0.75);
        cancel.setText(DISMISS);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchViewDVTNotification.this.destroy();
            }
        });
    }
}

