/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class SelectedResourcesResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        Collection<IResource> resources = Utils.getSelectedResources();
        if (resources.isEmpty()) {
            return "";
        }
        String name = variable.getName();
        HashSet<String> strings = new HashSet<String>();
        IPath path = null;
        URI uri = null;
        if (name.endsWith("_loc")) {
            for (IResource resource : resources) {
                File file;
                if (resource.isVirtual()) {
                    file = DVTFileUtils.getInstance().resolveAutoLinkPath(resource).toFile();
                    if (file == null || !file.exists()) continue;
                    strings.add(file.getAbsolutePath());
                    continue;
                }
                uri = resource.getLocationURI();
                if (uri == null || (file = EFS.getStore((URI)uri).toLocalFile(0, null)) == null) continue;
                strings.add(file.getAbsolutePath());
            }
        } else if (name.endsWith("_path")) {
            for (IResource resource : resources) {
                path = resource.getFullPath();
                if (path == null) continue;
                strings.add(path.toOSString());
            }
        } else if (name.endsWith("_name")) {
            for (IResource resource : resources) {
                strings.add(resource.getName());
            }
        }
        if (strings.isEmpty()) {
            return "";
        }
        String separator = argument == null ? File.pathSeparator : argument;
        StringBuilder sb = new StringBuilder();
        Iterator iterator = strings.iterator();
        sb.append((String)iterator.next());
        while (iterator.hasNext()) {
            sb.append(separator);
            sb.append((String)iterator.next());
        }
        return sb.toString();
    }
}

