/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTNotification;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class SimpleDVTNotification
extends DVTNotification {
    private Map<String, Runnable> fListeners = new HashMap<String, Runnable>();
    private String fText;
    private Link fLink;

    public SimpleDVTNotification(IDVTNotificationsHost host, int style, String family) {
        super(host, style, family);
    }

    @Override
    protected void createNotificationContents(Composite parent) {
        if (this.fText == null) {
            return;
        }
        this.fLink = new Link(parent, 64);
        this.fLink.setText(this.fText);
        DVTUiUtils.setPlatformLinkColor((Link)this.fLink);
        DVTColorUtil.INSTANCE.setForeground((Control)this.fLink, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"));
        GridDataFactory.fillDefaults().grab(true, true).hint(100, -1).applyTo((Control)this.fLink);
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Runnable r = SimpleDVTNotification.this.fListeners.get(e.text);
                if (r != null) {
                    r.run();
                }
            }
        });
    }

    public SimpleDVTNotification setText(String text) {
        this.fText = text;
        return this;
    }

    public SimpleDVTNotification setListener(String href, Runnable r) {
        this.fListeners.put(href, r);
        return this;
    }

    @Override
    public SimpleDVTNotification setShowPreferenceKey(String prefKey) {
        this.fShowPreferenceKey = prefKey;
        return this;
    }

    @Override
    public SimpleDVTNotification disableTimeout() {
        this.fHasTimeout = false;
        return this;
    }

    public void resetText(String text) {
        this.fText = text;
        this.fLink.setText(text);
        Composite notificationComposite = this.getNotificationComposite();
        if (notificationComposite == null) {
            return;
        }
        notificationComposite.layout();
    }
}

