/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.LinkedList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class StyledTextUndoRedo
implements KeyListener,
ExtendedModifyListener,
DisposeListener {
    private StyledText styledText;
    private UndoRedoStack<ExtendedModifyEvent> stack;
    private boolean isUndo;
    private boolean isRedo;

    private StyledTextUndoRedo(StyledText styledText) {
        this.styledText = styledText;
        this.styledText.addExtendedModifyListener((ExtendedModifyListener)this);
        this.styledText.addKeyListener((KeyListener)this);
        this.styledText.addDisposeListener((DisposeListener)this);
        this.stack = new UndoRedoStack();
    }

    public void keyPressed(KeyEvent e) {
        if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && (e.stateMask & SWT.MOD2) == SWT.MOD2 && e.keyCode == 122) {
            this.redo();
        } else if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 121) {
            this.redo();
        } else if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 122) {
            this.undo();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void modifyText(ExtendedModifyEvent event) {
        if (this.isUndo) {
            this.stack.pushRedo(event);
        } else {
            this.stack.pushUndo(event);
            if (!this.isRedo) {
                this.stack.clearRedo();
            }
        }
    }

    private void undo() {
        if (this.stack.hasUndo()) {
            this.isUndo = true;
            this.revertEvent(this.stack.popUndo());
            this.isUndo = false;
        }
    }

    private void redo() {
        if (this.stack.hasRedo()) {
            this.isRedo = true;
            this.revertEvent(this.stack.popRedo());
            this.isRedo = false;
        }
    }

    private void revertEvent(ExtendedModifyEvent event) {
        this.styledText.replaceTextRange(event.start, event.length, event.replacedText);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (event.widget == this.styledText) {
            if (!this.styledText.isDisposed()) {
                this.styledText.removeKeyListener((KeyListener)this);
                this.styledText.addExtendedModifyListener((ExtendedModifyListener)this);
            }
            this.stack.clearAll();
            this.stack = null;
        }
    }

    public static void install(StyledText styledText) {
        new StyledTextUndoRedo(styledText);
    }

    private static class UndoRedoStack<T> {
        private final int MAX_CAPACITY = 1000;
        private final LinkedList<T> undo = new LinkedList();
        private final LinkedList<T> redo = new LinkedList();

        public void pushUndo(T delta) {
            if (this.undo.size() >= 1000) {
                this.undo.removeLast();
            }
            this.undo.addFirst(delta);
        }

        public void pushRedo(T delta) {
            if (this.undo.size() >= 1000) {
                this.redo.removeLast();
            }
            this.redo.addFirst(delta);
        }

        public T popUndo() {
            return this.undo.pollFirst();
        }

        public T popRedo() {
            return this.redo.pollFirst();
        }

        public void clearUndo() {
            this.redo.clear();
        }

        public void clearRedo() {
            this.redo.clear();
        }

        public boolean hasUndo() {
            return !this.undo.isEmpty();
        }

        public boolean hasRedo() {
            return !this.redo.isEmpty();
        }

        public void clearAll() {
            this.clearUndo();
            this.clearRedo();
        }
    }
}

