/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Text;

public class TextDelayedModifyListener
extends Job
implements DisposeListener {
    private final Text widget;
    private final int delay;
    private final Consumer<String> action;
    private volatile String content = "";

    private TextDelayedModifyListener(Text widget, int delay, Consumer<String> action) {
        super("SWT Text Delayed Modify Listener Job");
        this.setPriority(10);
        this.setSystem(true);
        this.widget = widget;
        this.action = action;
        this.delay = delay;
        this.widget.addListener(24, event -> {
            if (this.widget.isDisposed()) {
                return;
            }
            this.content = this.widget.getText();
            this.cancel();
            this.schedule(this.delay);
        });
        this.widget.addDisposeListener((DisposeListener)this);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.cancel();
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.action.accept(this.content);
        return Status.OK_STATUS;
    }

    public static void install(Text textWidget, Consumer<String> action) {
        new TextDelayedModifyListener(textWidget, 200, action);
    }

    public static void install(Text textWidget, int delay, Consumer<String> action) {
        new TextDelayedModifyListener(textWidget, delay, action);
    }
}

