/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.osgi.framework.Bundle;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.UtilsCommon;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaPosition;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.custompragma.TranslatePragma;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.formatter.ForceFormatterDialog;
import ro.amiq.dvt.ui.icons.IconImageDescriptor;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class Utils
extends UtilsCommon {
    private static final IPath ICONS_PATH = new Path("$nl$/icons");

    public static void setTextWithMore(Text textWidget, Link link, final String title, final String text, int maxHeight, int width, int height) {
        final int dialogWidth = width;
        final int dialogHeight = height;
        if (text == null) {
            return;
        }
        GC gc = new GC((Drawable)textWidget);
        String shortened = text;
        while (shortened.length() > 0 && gc.textExtent((String)shortened).y >= maxHeight || shortened.length() > 500) {
            int indexOfNewline = shortened.lastIndexOf(10);
            if (indexOfNewline == -1) break;
            shortened = shortened.substring(0, indexOfNewline);
        }
        if (shortened.length() != text.length()) {
            textWidget.setText(shortened);
            link.setText("<a>[more]</a>");
        } else {
            textWidget.setText(shortened);
            link.setText("");
        }
        DVTUiUtils.setPlatformLinkColor((Link)link);
        gc.dispose();
        if (link.getData("ro.amiq.dvt.setTextWithMoreListenerKey") instanceof SelectionListener) {
            link.removeSelectionListener((SelectionListener)link.getData("ro.amiq.dvt.setTextWithMoreListenerKey"));
        }
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        new MoreMessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title == null ? "" : title, MessageDialog.getDefaultImage(), null, 0, new String[]{"Close"}, 0, title, text, dialogWidth, dialogHeight).open();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        link.addSelectionListener(listener);
        link.setData("ro.amiq.dvt.setTextWithMoreListenerKey", (Object)listener);
    }

    public static void setTextWithMore(Text textWidget, Link link, String title, String text, int maxHeight) {
        Utils.setTextWithMore(textWidget, link, title, text, maxHeight, 500, 350);
    }

    public static List<IProject> selectProjects(String[] natureIds, String message, ILabelProvider labelProvider, IProject[] defaultSelection) {
        ArrayList<IProject> natureMatchingProjects = Utils.getNatureMatchingProjects(natureIds);
        if (natureMatchingProjects.size() < 2) {
            return natureMatchingProjects;
        }
        return Utils.selectProjects(natureMatchingProjects.toArray(new IProject[natureMatchingProjects.size()]), message, labelProvider, defaultSelection);
    }

    public static IProject selectProject(final IProject[] projects, final String message, final ILabelProvider labelProvider, final IProject defaultSelection) {
        final IProject[] result = new IProject[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)(labelProvider == null ? new WorkbenchLabelProvider() : labelProvider));
                dialog.setElements((Object[])projects);
                dialog.setTitle("Select Workspace Project");
                dialog.setMessage(message);
                if (defaultSelection != null) {
                    dialog.setInitialSelections((Object[])new IProject[]{defaultSelection});
                }
                if (dialog.open() == 0) {
                    result[0] = (IProject)dialog.getFirstResult();
                }
            }
        });
        return result[0];
    }

    @NotNull
    public static ArrayList<IProject> getNatureMatchingProjects(String[] natureIds) {
        if (natureIds == null) {
            natureIds = new String[]{};
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] allProjects = workspace.getRoot().getProjects();
        ArrayList<IProject> natureMatchingProjects = new ArrayList<IProject>();
        try {
            int i = 0;
            while (i < allProjects.length) {
                if (allProjects[i].isAccessible()) {
                    if (natureIds.length == 0) {
                        natureMatchingProjects.add(allProjects[i]);
                    } else {
                        String[] stringArray = natureIds;
                        int n = natureIds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String natureId = stringArray[n2];
                            if (allProjects[i].isNatureEnabled(natureId)) {
                                natureMatchingProjects.add(allProjects[i]);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return natureMatchingProjects;
    }

    public static IProject selectProject(String[] natureIds, String message, ILabelProvider labelProvider, IProject defaultSelection) {
        ArrayList<IProject> natureMatchingProjects = Utils.getNatureMatchingProjects(natureIds);
        if (natureMatchingProjects.isEmpty()) {
            return null;
        }
        if (natureMatchingProjects.size() == 1) {
            return (IProject)natureMatchingProjects.get(0);
        }
        return Utils.selectProject(natureMatchingProjects.toArray(new IProject[natureMatchingProjects.size()]), message, labelProvider, defaultSelection);
    }

    public static List<IProject> selectProjects(final IProject[] projects, final String message, final ILabelProvider labelProvider, final IProject[] defaultSelection) {
        final ArrayList<IProject> result = new ArrayList<IProject>();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ListSelectionDialog dialog = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)projects, new IStructuredContentProvider(){

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }

                    public void dispose() {
                    }

                    public Object[] getElements(Object inputElement) {
                        return projects;
                    }
                }, (ILabelProvider)(labelProvider == null ? new WorkbenchLabelProvider() : labelProvider), message);
                if (defaultSelection != null) {
                    dialog.setInitialElementSelections(Arrays.asList(defaultSelection));
                }
                dialog.setTitle("Select Workspace Project");
                if (dialog.open() == 0) {
                    Object[] dialogResult;
                    Object[] objectArray = dialogResult = dialog.getResult();
                    int n = dialogResult.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object resultProject = objectArray[n2];
                        if (resultProject instanceof IProject) {
                            result.add((IProject)resultProject);
                        }
                        ++n2;
                    }
                }
            }
        });
        return result;
    }

    public static Shell getActiveShell() {
        try {
            final Shell[] shell = new Shell[1];
            final IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        shell[0] = workbench.getActiveWorkbenchWindow().getShell();
                    }
                    catch (Exception exception) {}
                }
            });
            return shell[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void popMessage(final int kind, final String title, final String message) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (shell == null) {
                    return;
                }
                new MessageDialog(shell, title, null, message, kind, new String[]{"OK"}, 0).open();
            }
        });
    }

    public static Collection<IResource> getSelectedResources() {
        if (PlatformUI.getWorkbench().getDisplay().getThread().equals(Thread.currentThread())) {
            return Utils.getSelectedResources0();
        }
        final HashSet<IResource> resources = new HashSet<IResource>();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                resources.addAll(Utils.getSelectedResources0());
            }
        });
        return resources;
    }

    private static Collection<IResource> getSelectedResources0() {
        IWorkbenchPage page;
        HashSet<IResource> resources = new HashSet<IResource>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IResource resource = null;
        if (window != null && (page = window.getActivePage()) != null) {
            IStructuredSelection ss;
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IEditorPart) {
                IEditorPart epart = (IEditorPart)part;
                resource = (IResource)epart.getEditorInput().getAdapter(IResource.class);
                if (resource != null) {
                    resources.add(resource);
                }
            } else if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                for (Object next : ss) {
                    resource = (IResource)Platform.getAdapterManager().getAdapter(next, IResource.class);
                    if (resource == null) continue;
                    resources.add(resource);
                }
            }
        }
        return resources;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        final IWorkbenchWindow[] result = new IWorkbenchWindow[1];
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = workbench.getActiveWorkbenchWindow();
            }
        });
        return result[0];
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = Utils.getActiveWorkbenchWindow();
        if (w == null) {
            return null;
        }
        return w.getActivePage();
    }

    public static IWorkbenchWindow[] getAllWorkbenchWindows() {
        final ArrayList result = new ArrayList();
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    result.add(window);
                    ++n2;
                }
            }
        });
        return result.toArray(new IWorkbenchWindow[result.size()]);
    }

    public static Point computeSizeConstraints(Control control, int widthInChars, int heightInChars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }

    public static int getStartIndentationOffset(int lineNo, IDocument document) {
        if (lineNo < 0) {
            return 0;
        }
        try {
            int lineLength = document.getLineLength(lineNo);
            int lineOffset = document.getLineOffset(lineNo);
            String currentLine = document.get(lineOffset, lineLength);
            int currentLineIndent = Utils.getTrimOffset(currentLine);
            if (currentLineIndent > -1) {
                return lineOffset + currentLineIndent;
            }
            int prevLineOffset = document.getLineOffset(lineNo - 1);
            int prevLineLength = document.getLineLength(lineNo - 1);
            String prevLine = document.get(prevLineOffset, prevLineLength);
            String prevLineTrim = prevLine.trim();
            while (prevLineTrim.isEmpty() && lineNo > 0) {
                prevLineOffset = document.getLineOffset(--lineNo - 1);
                prevLineLength = document.getLineLength(lineNo - 1);
                prevLine = document.get(prevLineOffset, prevLineLength);
                prevLineTrim = prevLine.trim();
            }
            return prevLineOffset + Utils.getTrimOffset(prevLine);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 0;
        }
    }

    public static List<IFile> getCurrentlyEditedFiles() {
        final ArrayList<IFile> result = new ArrayList<IFile>();
        Shell activeShell = Utils.getActiveShell();
        if (activeShell == null || activeShell.getDisplay() == null) {
            return result;
        }
        activeShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] references;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IEditorReference[] iEditorReferenceArray = references = workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file;
                    IEditorReference reference = iEditorReferenceArray[n2];
                    IEditorPart editor = reference.getEditor(false);
                    if (editor != null && editor instanceof DVTEditor && (file = (IFile)editor.getAdapter(IResource.class)) != null) {
                        result.add(file);
                    }
                    ++n2;
                }
            }
        });
        return result;
    }

    public static List<IEditorReference> getCurrentlyOpenEditorReferences() {
        final ArrayList<IEditorReference> result = new ArrayList<IEditorReference>();
        Shell activeShell = Utils.getActiveShell();
        if (activeShell == null || activeShell.getDisplay() == null) {
            return result;
        }
        activeShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] references;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IEditorReference[] iEditorReferenceArray = references = workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    result.add(reference);
                    ++n2;
                }
            }
        });
        return result;
    }

    public static List<IEditorPart> getCurrentlyOpenEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>();
        Shell activeShell = Utils.getActiveShell();
        if (activeShell == null || activeShell.getDisplay() == null) {
            return result;
        }
        activeShell.getDisplay().syncExec(() -> {
            IEditorReference[] references;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IEditorReference[] iEditorReferenceArray = references = activePage.getEditorReferences();
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                IEditorPart editor = reference.getEditor(false);
                result.add(editor);
                ++n2;
            }
        });
        return result;
    }

    public static void closeOpenEditors(Display display, IProject project) {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            final HashMap editorsToBeClosed = new HashMap();
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                if (window != null) {
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        if (page != null) {
                            ArrayList<IEditorReference> pageEditorsToBeClosed = new ArrayList<IEditorReference>();
                            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                            int n5 = iEditorReferenceArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IProject editorProject;
                                IEditorInput editorInput;
                                IEditorReference editorReference = iEditorReferenceArray[n6];
                                if (editorReference != null && (editorInput = editorReference.getEditorInput()) != null && (editorProject = (IProject)editorInput.getAdapter(IProject.class)) != null && editorProject.equals((Object)project)) {
                                    pageEditorsToBeClosed.add(editorReference);
                                }
                                ++n6;
                            }
                            if (!pageEditorsToBeClosed.isEmpty()) {
                                editorsToBeClosed.put(page, pageEditorsToBeClosed);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IWorkbenchPage page : editorsToBeClosed.keySet()) {
                        List editors = (List)editorsToBeClosed.get(page);
                        IEditorReference[] editorRefs = editors.toArray(new IEditorReference[editors.size()]);
                        page.closeEditors(editorRefs, false);
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void safeRunSynchInUIThread(Runnable runnable) {
        if (Display.getCurrent() == null) {
            Shell activeShell = Utils.getActiveShell();
            if (activeShell != null) {
                activeShell.getDisplay().syncExec(runnable);
            }
        } else {
            runnable.run();
        }
    }

    public static void safeRunAsynchInUIThread(Runnable runnable) {
        if (Display.getCurrent() == null) {
            Shell activeShell = Utils.getActiveShell();
            if (activeShell != null) {
                activeShell.getDisplay().asyncExec(runnable);
            }
        } else {
            runnable.run();
        }
    }

    public static void openHelpPage(LanguageKind language, String page) {
        String plugin = null;
        if (language == LanguageKind.E) {
            plugin = "edt";
        } else if (language == LanguageKind.VHDL) {
            plugin = "vhdldt";
        } else if (language == LanguageKind.VLOG) {
            plugin = "vlogdt";
        } else if (language == LanguageKind.SLN) {
            plugin = "slndt";
        } else if (language == LanguageKind.MSDL) {
            plugin = "msdldt";
        } else if (language == LanguageKind.PSS) {
            plugin = "pssdt";
        }
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/ro.amiq." + plugin + ".help/help/" + page);
    }

    public static ImageDescriptor createDescriptor(String prefix, String name) {
        return new IconImageDescriptor(FileLocator.find((Bundle)DVTPlugin.getDefault().getBundle(), (IPath)ICONS_PATH.append(prefix).append(name), null));
    }

    public static void syncExec(Runnable r) {
        Shell activeShell = Utils.getActiveShell();
        if (activeShell == null) {
            return;
        }
        Display display = activeShell.getDisplay();
        if (display == null) {
            return;
        }
        display.syncExec(r);
    }

    public static void asyncExec(Runnable r) {
        Shell activeShell = Utils.getActiveShell();
        if (activeShell == null) {
            return;
        }
        Display display = activeShell.getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(r);
    }

    private static List<IEditorReference> getGrayEditorReferences() {
        ArrayList<IEditorReference> grayEditors = new ArrayList<IEditorReference>();
        try {
            List<IEditorReference> editorReferences = Utils.getCurrentlyOpenEditorReferences();
            if (editorReferences == null) {
                return grayEditors;
            }
            for (IEditorReference editorReference : editorReferences) {
                IEditorInput input = editorReference.getEditorInput();
                if (!(input instanceof FileStoreEditorInput)) continue;
                grayEditors.add(editorReference);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return grayEditors;
    }

    public static void swapGrayEditors(IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                List<IEditorReference> grayEditorReferences = Utils.getGrayEditorReferences();
                if (grayEditorReferences == null || grayEditorReferences.isEmpty()) {
                    return;
                }
                for (IEditorReference editorReference : grayEditorReferences) {
                    IFile projectFile;
                    String fileFullPath;
                    FileStoreEditorInput inputFileStore;
                    URI inputURI;
                    IEditorInput oldInput = editorReference.getEditorInput();
                    if (!(oldInput instanceof FileStoreEditorInput) || (inputURI = (inputFileStore = (FileStoreEditorInput)oldInput).getURI()) == null || (fileFullPath = inputURI.getPath()) == null || (projectFile = DVTFileUtils.getInstance().getProjectFile(project, fileFullPath)) == null) continue;
                    try {
                        projectFile.refreshLocal(2, null);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    IEditorPart editor = editorReference.getEditor(true);
                    if (!(editor instanceof AbstractTextEditor)) {
                        return;
                    }
                    ISelectionProvider selectionProvider = ((AbstractTextEditor)editor).getSelectionProvider();
                    if (selectionProvider == null) {
                        return;
                    }
                    ISelection selection = selectionProvider.getSelection();
                    ((AbstractTextEditor)editor).setInput((IEditorInput)new FileEditorInput(projectFile));
                    if (!(selection instanceof ITextSelection)) {
                        return;
                    }
                    ((AbstractTextEditor)editor).selectAndReveal(((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength());
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static void addCustomPragmasPositions(Collection<CustomPragmaUsage> pragmas, Set<DVTSemanticFoldingPosition> foldingPositions, IDocument document) {
        try {
            if (pragmas == null || document == null || foldingPositions == null) {
                return;
            }
            CustomPragmaUsage[] customPragmas = pragmas.toArray(new CustomPragmaUsage[pragmas.size()]);
            int length = customPragmas.length;
            HashMap<Integer, CustomPragmaPosition> customPragmaPositions = new HashMap<Integer, CustomPragmaPosition>();
            CustomPragmaUsage startPragma = null;
            CustomPragmaUsage endPragma = null;
            ArrayList<Position> translatePragmas = new ArrayList<Position>();
            int i = 0;
            while (i < length) {
                if (customPragmas[i].isValid()) {
                    if (startPragma == null) {
                        startPragma = customPragmas[i];
                    } else {
                        endPragma = customPragmas[i];
                        int startOffset = DVTDocumentUtils.documentLineOffset(document, startPragma.getLine() - 1);
                        int endOffset = DVTDocumentUtils.documentLineOffset(document, endPragma.getLine() - 1) + document.getLineLength(endPragma.getLine() - 1);
                        CustomPragma pragma = startPragma.getPragma();
                        if (pragma instanceof TranslatePragma) {
                            translatePragmas.add(new DVTPosition(startOffset, endOffset - startOffset));
                            startPragma = null;
                            endPragma = null;
                        } else {
                            customPragmaPositions.put(startOffset, new CustomPragmaPosition(startOffset, endOffset - startOffset, pragma.isReadOnly(), pragma.getName()));
                            foldingPositions.add(new DVTSemanticFoldingPosition(startOffset, endOffset - startOffset, "custom"));
                            startPragma = null;
                            endPragma = null;
                        }
                    }
                }
                ++i;
            }
            for (CustomPragmaPosition position : customPragmaPositions.values()) {
                DVTDocumentUtils.addDocumentPosition(document, "CUSTOM_PRAGMA", position);
            }
            Utils.addTranslatePragmas(translatePragmas, document);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void addTranslatePragmas(ArrayList<Position> translatePragmas, IDocument document) throws Exception {
        if (!document.containsPositionCategory("__dvt_inactive_code_position")) {
            document.addPositionCategory("__dvt_inactive_code_position");
        }
        for (Position translatePragma : translatePragmas) {
            DVTDocumentUtils.addDocumentPosition(document, "__dvt_inactive_code_position", translatePragma);
        }
    }

    public static String pasteFromClipboard() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        TextTransfer textTransfer = TextTransfer.getInstance();
        String textData = (String)clipboard.getContents((Transfer)textTransfer);
        clipboard.dispose();
        return textData;
    }

    public static List<IEditorPart> computeVisibleEditors() {
        IWorkbenchPage page = DVTUiUtils.getActivePage();
        if (page == null) {
            return Collections.emptyList();
        }
        IEditorReference[] editorReferences = page.getEditorReferences();
        if (editorReferences == null) {
            return Collections.emptyList();
        }
        ArrayList<IEditorPart> visibleEditors = new ArrayList<IEditorPart>();
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            IWorkbenchPart part = reference.getPart(false);
            if (part != null && page.isPartVisible(part)) {
                visibleEditors.add(reference.getEditor(false));
            }
            ++n2;
        }
        return visibleEditors;
    }

    public static void setEnabledRecursive(Composite composite, boolean enabled) {
        composite.setEnabled(enabled);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                Utils.setEnabledRecursive((Composite)child, enabled);
            } else {
                child.setEnabled(enabled);
            }
            ++n2;
        }
    }

    public static void popFormatFailed(final String msg) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Format failed", null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        });
    }

    public static boolean forceFormatter(int fCodeFormattingThreshold) {
        ForceFormatterDialog forceFormatterDialog = new ForceFormatterDialog(fCodeFormattingThreshold);
        return forceFormatterDialog.open() != 0;
    }

    public static Region getEditorVisibleLimits(ITextViewer textViewer) {
        return Utils.getEditorVisibleLimits(textViewer, 1);
    }

    public static Region getEditorVisibleLimits(ITextViewer textViewer, int regionMultiplier) {
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        int[] visibleOffsets = new int[]{-1, -1};
        Display.getDefault().syncExec(() -> {
            try {
                if (textViewer == null || textViewer.getDocument() == null) {
                    return;
                }
                nArray[0] = textViewer.getTopIndexStartOffset();
                nArray[1] = textViewer.getBottomIndexEndOffset();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
        int startOffset = visibleOffsets[0];
        int endOffset = visibleOffsets[1];
        if (startOffset < 0 || endOffset < 0) {
            return null;
        }
        int size = endOffset - startOffset;
        if (size < 0) {
            return null;
        }
        startOffset = Math.max(0, startOffset - 3 * regionMultiplier * size);
        endOffset = Math.min(textViewer.getDocument().getLength(), endOffset + 3 * regionMultiplier * size);
        size = endOffset - startOffset;
        if (size < 0) {
            return null;
        }
        return new Region(startOffset, endOffset - startOffset);
    }

    public static ITypedRegion limitTypedRegionToVisibleArea(ITypedRegion region, ITextViewer textViewer) {
        if (textViewer == null || TestHelper.isTestMode()) {
            return null;
        }
        Region limits = Utils.getEditorVisibleLimits(textViewer);
        if (limits == null) {
            return null;
        }
        if (region.getOffset() + region.getLength() < limits.getOffset()) {
            return null;
        }
        if (region.getOffset() > limits.getOffset() + limits.getLength()) {
            return null;
        }
        int newStartOffset = region.getOffset();
        int newEndOffset = region.getOffset() + region.getLength();
        if (region.getOffset() < limits.getOffset()) {
            newStartOffset = limits.getOffset();
        }
        if (newEndOffset > limits.getOffset() + limits.getLength()) {
            newEndOffset = limits.getOffset() + limits.getLength();
        }
        if (newStartOffset > region.getOffset() || newEndOffset < region.getOffset() + region.getLength()) {
            region = new TypedRegion(newStartOffset, newEndOffset - newStartOffset, region.getType());
        }
        return region;
    }

    public static String computeMethodOverrideIndicationMessageWithHyperlink(String message, IRfDefElement parentDecl) {
        return message;
    }

    public static final void setWidgetSWTBotId(Widget widget, String id) {
        widget.setData("org.eclipse.swtbot.widget.key", (Object)id);
    }

    public static final class MoreMessageDialog
    extends MessageDialog {
        private final String title;
        private final String text;
        private final int dialogWidth;
        private final int dialogHeight;

        public MoreMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String title, String text, int dialogWidth, int dialogHeight) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.title = title;
            this.text = text;
            this.dialogWidth = dialogWidth;
            this.dialogHeight = dialogHeight;
            this.setShellStyle(3312);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createCustomArea(Composite parent) {
            this.getShell().setSize(this.dialogWidth, this.dialogHeight);
            this.getShell().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 27) {
                        this.getShell().dispose();
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            parent.setLayout((Layout)new FillLayout());
            final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2560);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            final Composite container = new Composite((Composite)scrolledComposite, 0);
            container.setLayout((Layout)new FillLayout());
            Text label = new Text(container, 72);
            label.setText(String.valueOf(this.title) + "\n\n" + this.text);
            DVTColorUtil.INSTANCE.setBackground((Control)label, DVTColorUtil.INSTANCE.getSystemColor(25), true);
            label.setFont(JFaceResources.getTextFont());
            scrolledComposite.setContent((Control)container);
            scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = scrolledComposite.getClientArea();
                    scrolledComposite.setMinSize(container.computeSize(r.width, -1));
                }
            });
            return label;
        }
    }
}

