/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.filebuffers.SynchronizableDocument;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;

public abstract class UtilsCommon {
    protected static final Pattern NEWLINE_PATTERN = Pattern.compile("(?:\\r\\n)|(?:[\\r\\n])");

    public static String formatString(Supplier<DVTSourceViewerConfiguration> createConfig, String text, IDocument detectIndentationDoc, String indentation, boolean ignoreFirstLine) {
        return UtilsCommon.formatStringInternal(createConfig, text, detectIndentationDoc, indentation, ignoreFirstLine, false);
    }

    public static String indentString(Supplier<DVTSourceViewerConfiguration> createConfig, String text, IDocument detectIndentationDoc, String indentation, boolean ignoreFirstLine) {
        return UtilsCommon.formatStringInternal(createConfig, text, detectIndentationDoc, indentation, ignoreFirstLine, true);
    }

    private static String formatStringInternal(Supplier<DVTSourceViewerConfiguration> createConfig, String text, IDocument detectIndentationDoc, String indentation, boolean ignoreFirstLine, boolean onlyIndent) {
        if (createConfig == null || text == null) {
            return null;
        }
        DVTSourceViewerConfiguration config = createConfig.get();
        if (config == null) {
            return null;
        }
        if (text.isEmpty()) {
            return text;
        }
        DVTContentFormatter formatter = (DVTContentFormatter)config.getContentFormatter(null);
        config.detectIndentation(detectIndentationDoc);
        IDocument insertDoc = UtilsCommon.createDocument(config, text);
        if (insertDoc == null) {
            return null;
        }
        indentation = TextUtils.replaceTabsWithSpacesVisual(indentation, config.getTabWidth());
        formatter.format(insertDoc, (IRegion)new Region(0, insertDoc.getLength()), indentation, ignoreFirstLine, config.getLanguageKind(), onlyIndent);
        config.dispose();
        return insertDoc.get();
    }

    public static IDocument createDocument(DVTSourceViewerConfiguration config, String text) {
        if (config == null || text == null) {
            return null;
        }
        SynchronizableDocument document = new SynchronizableDocument();
        document.set(text);
        config.setupDocumentPartitioner((IDocument)document);
        return document;
    }

    public static String getStartIndentation(int lineNo, IDocument document) {
        if (lineNo < 0) {
            return "";
        }
        try {
            int lineLength = document.getLineLength(lineNo);
            int lineOffset = document.getLineOffset(lineNo);
            String currentLine = document.get(lineOffset, lineLength);
            int currentLineIndent = Utils.getTrimOffset(currentLine);
            if (currentLineIndent > -1) {
                return UtilsCommon.getReplacementString(currentLineIndent);
            }
            int prevLineOffset = document.getLineOffset(lineNo - 1);
            int prevLineLength = document.getLineLength(lineNo - 1);
            String prevLine = document.get(prevLineOffset, prevLineLength);
            String prevLineTrim = prevLine.trim();
            while (prevLineTrim.isEmpty() && lineNo > 0) {
                prevLineOffset = document.getLineOffset(--lineNo - 1);
                prevLineLength = document.getLineLength(lineNo - 1);
                prevLine = document.get(prevLineOffset, prevLineLength);
                prevLineTrim = prevLine.trim();
            }
            return UtilsCommon.getReplacementString(Utils.getTrimOffset(prevLine));
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public static String getReplacementString(int length) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < length) {
            str.append(' ');
            ++i;
        }
        return str.toString();
    }

    public static int getTrimOffset(String line) {
        String lineTrimmed = line.trim();
        if (lineTrimmed.isEmpty() && !line.isEmpty()) {
            Pattern pNL = NEWLINE_PATTERN;
            StringBuilder buffer = new StringBuilder(line);
            Matcher mNL = pNL.matcher(buffer);
            boolean endsWithNL = mNL.find();
            if (endsWithNL && mNL.start() != 0) {
                return buffer.substring(0, mNL.start()).length();
            }
            if (mNL.start() != 0) {
                return line.length();
            }
        } else {
            if (!lineTrimmed.isEmpty()) {
                return UtilsCommon.computeLineOffset(line, lineTrimmed);
            }
            if (line.isEmpty()) {
                return -1;
            }
        }
        return -1;
    }

    public static int getTabWidth(IPreferenceStore prefStore) {
        if (prefStore == null) {
            return 4;
        }
        return prefStore.getInt("tabWidth");
    }

    public static int getTabWidth() {
        return UtilsCommon.getTabWidth(DVTPlugin.getDefault().getCombinedPreferenceStore());
    }

    private static int computeLineOffset(String line, String lineTrimmed) {
        if (line == null || lineTrimmed == null) {
            return 0;
        }
        int indexOfFirstNWSChar = 0;
        int tabWidth = UtilsCommon.getTabWidth();
        String trimmedSubstring = line.substring(0, line.indexOf(lineTrimmed));
        int i = 0;
        while (i < trimmedSubstring.length()) {
            indexOfFirstNWSChar = trimmedSubstring.charAt(i) == '\t' ? (indexOfFirstNWSChar += tabWidth) : ++indexOfFirstNWSChar;
            ++i;
        }
        return indexOfFirstNWSChar;
    }

    public static IPropertyChangeListener setUpFoldingPreferencesListener(IPreferenceStore store, String codeFoldingEnabled, String manualCodeFoldingEnabled, String codeFoldingNofLines, DVTPresentationReconciler reconciler, DVTBaseScanner codeScanner, DVTBaseScanner commentScanner, DVTBaseScanner expansionScanner) {
        if (store == null || codeFoldingEnabled == null || manualCodeFoldingEnabled == null || codeFoldingNofLines == null) {
            return null;
        }
        IPropertyChangeListener fPrefListener = event -> {
            int manualFoldingEnabled;
            int foldingEnabled;
            int nofLines = store.getInt(codeFoldingNofLines);
            boolean enable = store.getBoolean(codeFoldingEnabled);
            boolean manualEnable = store.getBoolean(manualCodeFoldingEnabled);
            if (codeFoldingNofLines.equals(event.getProperty()) && event.getNewValue() instanceof Integer) {
                nofLines = (Integer)event.getNewValue();
            }
            if (codeFoldingEnabled.equals(event.getProperty()) && event.getNewValue() instanceof Boolean) {
                enable = (Boolean)event.getNewValue();
            }
            if (manualCodeFoldingEnabled.equals(event.getProperty()) && event.getNewValue() instanceof Boolean) {
                manualEnable = (Boolean)event.getNewValue();
            }
            int n = foldingEnabled = !enable ? 0 : nofLines;
            int n2 = !manualEnable ? 0 : (manualFoldingEnabled = !enable ? 0 : nofLines);
            if (reconciler != null) {
                reconciler.setNofLinesFolding(foldingEnabled);
            }
            if (codeScanner != null) {
                codeScanner.setNofLinesFolding(foldingEnabled);
            }
            if (commentScanner != null) {
                commentScanner.setNofLinesManualFolding(manualFoldingEnabled);
            }
            if (expansionScanner != null) {
                expansionScanner.setNofLinesManualFolding(manualFoldingEnabled);
            }
        };
        store.addPropertyChangeListener(fPrefListener);
        return fPrefListener;
    }
}

