/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import ro.amiq.dvt.ui.ButtonFactory;
import ro.amiq.dvt.ui.DVTNotification;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.UpdateJob;

public class ViewUpdateProgressNotification
extends DVTNotification {
    private IDVTNotificationsHost host;
    private UpdateJob job;
    private Label currentItemNoLabel;

    public ViewUpdateProgressNotification(IDVTNotificationsHost host, UpdateJob updateJob) {
        super(host, 256, "ViewUpdateProgressNotification");
        this.host = host;
        this.job = updateJob;
    }

    @Override
    protected void createNotificationContents(Composite parent) {
        this.currentItemNoLabel = new Label(parent, 0);
        this.currentItemNoLabel.setText("Computing instances: ...");
        DVTColorUtil.INSTANCE.setForeground((Control)this.currentItemNoLabel, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.currentItemNoLabel);
    }

    @Override
    protected void createButtons(Composite buttonsComposite) {
        Button cancel = ButtonFactory.INSTANCE.create(buttonsComposite, 0, 0.75);
        cancel.setText("Cancel");
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(ViewUpdateProgressNotification.this.host instanceof IUpdateJobImpl)) {
                    return;
                }
                ViewUpdateProgressNotification.this.job.cancel();
                ViewUpdateProgressNotification.this.destroy();
            }
        });
    }

    @Override
    public boolean create() {
        if (!super.create()) {
            return false;
        }
        UpdateNofElementsJob updateCounterJob = new UpdateNofElementsJob(this, this.job, this.currentItemNoLabel);
        updateCounterJob.schedule();
        return true;
    }

    @Override
    protected int getNotificationTimeout() {
        return Integer.MAX_VALUE;
    }

    private static class UpdateNofElementsJob
    extends Job {
        private ViewUpdateProgressNotification notification;
        private UpdateJob updateJob;
        private Label label;

        public UpdateNofElementsJob(ViewUpdateProgressNotification notification, UpdateJob job, Label label) {
            super("Update number of currently computed items");
            this.setSystem(true);
            this.notification = notification;
            this.updateJob = job;
            this.label = label;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int prevNofElements;
            int nofElements = prevNofElements = this.updateJob.getImplementation().getNofElements();
            while (true) {
                if (this.updateJob.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.label.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                prevNofElements = nofElements;
                nofElements = this.updateJob.getImplementation().getNofElements();
                if (nofElements - prevNofElements == 0) break;
                final int nofElementFinal = nofElements;
                Utils.safeRunSynchInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!label.isDisposed()) {
                            label.setText("Computing instances: " + nofElementFinal);
                        }
                    }
                });
            }
            Utils.safeRunSynchInUIThread(new Runnable(){

                @Override
                public void run() {
                    notification.destroy();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

