/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;

public class WhatsNewDelegate
extends AbstractHandler {
    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog messageDialog = new MessageDialog(shell, "What's New in DVT", DVTImages.imageCache.getImage(DVTImages.WHATS_NEW_IMAGE), "In order to obtain What's New information, DVT will connect to Internet. Do you want to proceed?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (messageDialog.open() == 0) {
            WhatsNewDialog dialog = new WhatsNewDialog(shell);
            dialog.open();
        }
        return null;
    }

    static class WhatsNewDialog
    extends Dialog {
        protected WhatsNewDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("What's New in DVT");
            shell.setImage(DVTImages.imageCache.getImage(DVTImages.WHATS_NEW_IMAGE));
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Control container = super.createDialogArea(parent);
            Composite composite = new Composite((Composite)container, 0);
            GridData gd = new GridData(4, 4, true, true);
            gd.minimumHeight = 600;
            gd.minimumWidth = 800;
            composite.setLayoutData((Object)gd);
            composite.setLayout((Layout)new GridLayout());
            String currentVersion = DVTPlugin.getDefault().getBundle().getVersion().toString();
            Label label = new Label(composite, 64);
            label.setText("Your current DVT version is: " + currentVersion);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            CTabFolder tabFolder = new CTabFolder(composite, 0);
            tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            ArrayList<WhatNewTabItemWrapper> tabWrappers = new ArrayList<WhatNewTabItemWrapper>();
            tabWrappers.add(new WhatNewTabItemWrapper(tabFolder, "eDT", DVTImages.imageCache.getImage(DVTImages.E_PERSPECTIVE), "eDT - What's new", "https://eda.amiq.com/documentation/eclipse/elang/toc/whats-new", "ro.amiq.edt.ui.perspectives.EDTPerspective"));
            tabWrappers.add(new WhatNewTabItemWrapper(tabFolder, "VlogDT", DVTImages.imageCache.getImage(DVTImages.VLOG_PERSPECTIVE), "VlogDT - What's new", "https://eda.amiq.com/documentation/eclipse/sv/toc/whats-new", "ro.amiq.vlogdt.ui.perspectives.VlogPerspective"));
            tabWrappers.add(new WhatNewTabItemWrapper(tabFolder, "VhdlDT", DVTImages.imageCache.getImage(DVTImages.VHDL_PERSPECTIVE), "VhdlDT - What's new", "https://eda.amiq.com/documentation/eclipse/vhdl/toc/whats-new", "ro.amiq.vhdldt.ui.perspectives.VhdlPerspective"));
            tabWrappers.add(new WhatNewTabItemWrapper(tabFolder, "PssDT", DVTImages.imageCache.getImage(DVTImages.PSS_PERSPECTIVE), "PssDT - What's new", "https://eda.amiq.com/documentation/eclipse/pss/toc/whats-new", "ro.amiq.pssdt.ui.perspectives.PSSPerspective"));
            IPerspectiveDescriptor iPerspectiveDescriptor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
            for (WhatNewTabItemWrapper whatNewTabItemWrapper : tabWrappers) {
                if (!iPerspectiveDescriptor.getId().equals(whatNewTabItemWrapper.getPerspectiveId())) continue;
                tabFolder.setSelection(whatNewTabItemWrapper.getTabItem());
                tabFolder.setFocus();
            }
            return container;
        }

        static class WhatNewTabItemWrapper {
            private static final String DVT_ECLIPSE_SITE = "eda.amiq.com";
            private static final String BACK_MSG = "Back to What's New page";
            private static final String NETWORK_CONNECTION_MSG = "Connecting...";
            private static final String NETWORK_FAILURE_MSG = "Failed to connect!<br>This can happen if there is no Internet connection or the eda.amiq.com site is down.<br>You can try again by pressing 'Back to What's New page'.";
            private static final int NETWORK_TIMEOUT = 10000;
            private String fLink;
            private String fPerspectiveId;
            private final Shell fShell;
            private final CTabItem fTabItem;
            private Browser fBrowser;

            public WhatNewTabItemWrapper(CTabFolder parent, String title, Image image, String tooltip, String link, String perspectiveId) {
                this.fLink = link;
                this.fPerspectiveId = perspectiveId;
                this.fShell = parent.getShell();
                this.fTabItem = new CTabItem(parent, 0);
                this.fTabItem.setText("  " + title);
                this.fTabItem.setImage(image);
                this.fTabItem.setToolTipText(tooltip);
                this.fTabItem.setControl((Control)this.createTabComposite(parent));
            }

            public CTabItem getTabItem() {
                return this.fTabItem;
            }

            public String getPerspectiveId() {
                return this.fPerspectiveId;
            }

            private Composite createTabComposite(CTabFolder aTabFolder) {
                Composite tabComposite = new Composite((Composite)aTabFolder, 0);
                tabComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                tabComposite.setLayout((Layout)new GridLayout(2, false));
                Link link = new Link(tabComposite, 64);
                link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                link.setText("This data is fetched from: <A>" + this.fLink + "</A>");
                DVTUiUtils.setPlatformLinkColor((Link)link);
                link.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        Program.launch((String)fLink);
                    }
                });
                Button button = new Button(tabComposite, 8);
                button.setText(BACK_MSG);
                button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (fBrowser != null) {
                            fBrowser.setUrl(fLink);
                        }
                    }
                });
                try {
                    this.fBrowser = new Browser(tabComposite, 2048);
                    this.fBrowser.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                    this.fBrowser.addLocationListener(new LocationListener(){

                        public void changing(LocationEvent event) {
                            if (event.location != null) {
                                if (event.location.contains(WhatNewTabItemWrapper.DVT_ECLIPSE_SITE)) {
                                    if (event.widget instanceof Browser && ((Browser)event.widget).getData() != null) {
                                        ((Browser)event.widget).setData(null);
                                        return;
                                    }
                                    if (fShell == null || fShell.isDisposed()) {
                                        return;
                                    }
                                    event.doit = false;
                                    final String location = event.location;
                                    final Display display = fShell.getDisplay();
                                    new Thread(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         * Enabled aggressive block sorting
                                         * Enabled unnecessary exception pruning
                                         * Enabled aggressive exception aggregation
                                         * Converted monitor instructions to comments
                                         * Lifted jumps to return sites
                                         */
                                        @Override
                                        public void run() {
                                            this.setBrowserMessage(WhatNewTabItemWrapper.NETWORK_CONNECTION_MSG);
                                            URL url = null;
                                            URLConnection connection = null;
                                            try {
                                                url = new URL(location);
                                                connection = url.openConnection();
                                            }
                                            catch (Exception exception) {
                                                this.setBrowserMessage(WhatNewTabItemWrapper.NETWORK_FAILURE_MSG);
                                                return;
                                            }
                                            if (!(connection instanceof HttpURLConnection)) {
                                                this.setBrowserMessage(WhatNewTabItemWrapper.NETWORK_FAILURE_MSG);
                                                return;
                                            }
                                            final HttpURLConnection httpConnection = (HttpURLConnection)connection;
                                            httpConnection.setInstanceFollowRedirects(true);
                                            httpConnection.setRequestProperty("User-agent", "DVT");
                                            final Boolean[] isConnected = new Boolean[]{false};
                                            new Thread(new Runnable(){

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public void run() {
                                                    try {
                                                        try {
                                                            httpConnection.connect();
                                                            Boolean[] booleanArray = isConnected;
                                                            synchronized (isConnected) {
                                                                isConnected[0] = true;
                                                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                                            }
                                                        }
                                                        catch (SocketTimeoutException socketTimeoutException) {
                                                            httpConnection.disconnect();
                                                        }
                                                        catch (IOException iOException) {
                                                            httpConnection.disconnect();
                                                        }
                                                    }
                                                    finally {
                                                        httpConnection.disconnect();
                                                    }
                                                    {
                                                        return;
                                                    }
                                                }
                                            }).start();
                                            int delta = 10;
                                            int maxIterations = 10000 / delta;
                                            int iteration = 0;
                                            try {
                                                while (iteration < maxIterations) {
                                                    Boolean[] booleanArray = isConnected;
                                                    // MONITORENTER : isConnected
                                                    if (isConnected[0].booleanValue()) {
                                                        // MONITOREXIT : booleanArray
                                                        break;
                                                    }
                                                    // MONITOREXIT : booleanArray
                                                    Thread.sleep(delta);
                                                    ++iteration;
                                                }
                                            }
                                            catch (InterruptedException interruptedException) {}
                                            if (isConnected[0].booleanValue()) {
                                                this.setBrowserURL(location);
                                                return;
                                            }
                                            this.setBrowserMessage(WhatNewTabItemWrapper.NETWORK_FAILURE_MSG);
                                        }

                                        private void setBrowserMessage(final String text) {
                                            display.asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (fBrowser != null && !fBrowser.isDisposed()) {
                                                        fBrowser.setText(text);
                                                    }
                                                }
                                            });
                                        }

                                        private void setBrowserURL(final String url) {
                                            display.asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (fBrowser != null && !fBrowser.isDisposed()) {
                                                        fBrowser.setData(new Object());
                                                        fBrowser.setUrl(url);
                                                    }
                                                }
                                            });
                                        }
                                    }).start();
                                } else if (!event.location.equals("about:blank")) {
                                    event.doit = false;
                                }
                            }
                        }

                        public void changed(LocationEvent event) {
                        }
                    });
                    this.fBrowser.setUrl(this.fLink);
                }
                catch (SWTError e) {
                    DVTLogger.INSTANCE.logError((Throwable)new Exception(e));
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return tabComposite;
            }
        }
    }
}

