/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.DFSMEditorFactory;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.klay.KLayDiagramKind;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.AMenuCommandDelegateCommon;
import ro.amiq.dvt.ui.actions.AMenuCommandDelegateUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class AMenuCommandDelegate
extends AMenuCommandDelegateCommon {
    protected boolean showConnectionsOnPortDiagram(IDVTElementWrapper original, IRfPortElement port) {
        List<BreadcrumbSegment> segments;
        Object wrapperRfElement;
        Object topElement;
        IDVTElementWrapper instanceWrapper;
        block8: {
            block7: {
                try {
                    instanceWrapper = (IDVTElementWrapper)original.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PORT_INSTANCE);
                    topElement = null;
                    wrapperRfElement = null;
                    TreePath treePath = (TreePath)instanceWrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
                    wrapperRfElement = treePath != null ? treePath : instanceWrapper.getRfElement();
                    segments = null;
                    if (wrapperRfElement instanceof TreePath) {
                        TreePath parentWrapper = ((TreePath)wrapperRfElement).getParent();
                        topElement = parentWrapper == null || parentWrapper.equals(TreePath.TOP_DUMMY_TREE_PATH) ? wrapperRfElement : parentWrapper.getElement();
                        boolean includeSelf = parentWrapper == null || parentWrapper.equals(TreePath.TOP_DUMMY_TREE_PATH);
                        segments = DHBreadcrumbUtils.getSegmentsFromPath((TreePath)wrapperRfElement, includeSelf);
                        wrapperRfElement = ((TreePath)wrapperRfElement).getElement();
                    } else {
                        topElement = instanceWrapper.getParent() == null ? instanceWrapper.getRfElement() : instanceWrapper.getParent().getRfElement();
                        List<BreadcrumbSegment> list = segments = instanceWrapper.getParent() == null ? instanceWrapper.getAllElementsToRoot(true, false) : instanceWrapper.getParent().getAllElementsToRoot(true, false);
                    }
                    if (wrapperRfElement instanceof IRfNamedElement) break block7;
                    return false;
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                    return false;
                }
            }
            if (topElement instanceof TreePath) {
                topElement = ((TreePath)topElement).getElement();
            }
            if (topElement instanceof IRfNamedElement) break block8;
            return false;
        }
        NLConfig config = new NLConfig(DDesignEditorFactory.getInstance().getDefaultNLConfiguration());
        config.setActionKind(DMenuActionKind.SHOW_CONNECTIONS);
        BreadcrumbInput breadcrumbInput = new BreadcrumbInput(instanceWrapper.getProject(), segments, DiagramBreadcrumbUtils.getInstance().getBreadcrumbSerializer());
        config.setBreadcrumbInput(breadcrumbInput);
        DDesignEditorFactory.getInstance().newActionOnPortDiagram(1, (IRfNamedElement)topElement, (IRfNamedElement)wrapperRfElement, port, config, breadcrumbInput.getElementPath()).openEditor();
        return true;
    }

    protected boolean showDesignDiagramWithBreadcrumb(IDVTElementWrapper wrapper, String partID, IRfNamedElement namedElement) {
        ElementPath instancePath;
        List<BreadcrumbSegment> segments;
        IProject project;
        block33: {
            ELManager manager;
            block32: {
                block31: {
                    IRfSingleLangProject rfProject;
                    block30: {
                        block29: {
                            try {
                                if (namedElement != null) break block29;
                                return false;
                            }
                            catch (Throwable e) {
                                DVTLogger.INSTANCE.logError(e);
                                return false;
                            }
                        }
                        rfProject = namedElement.getRfProject();
                        if (rfProject != null) break block30;
                        return false;
                    }
                    project = rfProject.getProject();
                    if (project != null) break block31;
                    return false;
                }
                manager = RfMixedLangManager.getInstance().getELManager(project);
                if (manager != null) break block32;
                return false;
            }
            IELMemory memory = manager.getMemory();
            segments = null;
            ElementPath pathFromManager = null;
            if ("ro.amiq.dvt.ui.views.LazyDesignHierarchyView".equals(partID)) {
                TreePath treePath = (TreePath)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
                segments = DHBreadcrumbUtils.getSegmentsFromPath(treePath, true);
            } else if ("ro.amiq.dvt.ui.editor.breadcrumb.DHBreadcrumbViewer".equals(partID) || "ro.amiq.dvt.ui.editor.breadcrumb.ScopeBreadcrumbViewer".equals(partID)) {
                IRfNamedElement instanceToAppend = null;
                if (namedElement instanceof IRfDesignElement) {
                    instanceToAppend = AMenuCommandDelegateUtils.getInstance().getScopeElement(wrapper.getRfElement(IRfNamedElementAndScope.class), true);
                } else if (namedElement instanceof IRfInstanceElement) {
                    instanceToAppend = namedElement;
                }
                segments = AMenuCommandDelegateUtils.getInstance().getDHBreadcrumbFromEditor(DVTFileUtils.getInstance().getActiveEditor(), this.getNamedElement(wrapper), instanceToAppend, "ro.amiq.dvt.ui.editor.breadcrumb.DHBreadcrumbViewer".equals(partID));
            } else if ("ro.amiq.dvt.ui.editor.DVTEditor".equals(partID)) {
                IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
                if (activeEditor instanceof DVTEditor) {
                    IRfNamedElement instanceToAppend = null;
                    if (namedElement instanceof IRfDesignElement) {
                        instanceToAppend = AMenuCommandDelegateUtils.getInstance().getScopeElement(wrapper.getRfElement(IRfNamedElementAndScope.class), true);
                    } else if (namedElement instanceof IRfInstanceElement) {
                        instanceToAppend = namedElement;
                    }
                    DVTEditor editor = (DVTEditor)activeEditor;
                    ElementPath elementPath = pathFromManager = instanceToAppend == null ? null : DesignPathManager.getInstance().getPathFor(editor, instanceToAppend.getOffset(), instanceToAppend, null, true, false);
                }
                if (pathFromManager == DesignPathManager.FROZEN_MANAGER_EL_PATH) {
                    pathFromManager = null;
                }
                segments = DHBreadcrumbUtils.toBreadcrumbSegments(pathFromManager, true);
            }
            instancePath = pathFromManager;
            if (pathFromManager == null && segments == null && (namedElement instanceof IRfDesignElement || namedElement instanceof IRfInstanceElement)) {
                IRfDesignElement designElement = DesignUtils.getDesignElement(namedElement, wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH));
                List<ELInstance> instancesFor = memory.getInstancesFor(designElement, false, 1);
                if (instancesFor != null && !instancesFor.isEmpty()) {
                    ElementPath hierarchyPath = instancesFor.get(0).getHierarchyPath();
                    segments = DHBreadcrumbUtils.toBreadcrumbSegments(hierarchyPath, true);
                    instancePath = hierarchyPath;
                }
            } else {
                instancePath = this.getPathFromSegments(segments);
            }
            if ((namedElement = AMenuCommandDelegateUtils.getInstance().getNamedElement(project, namedElement, segments)) != null) break block33;
            return false;
        }
        if (instancePath == null) {
            instancePath = ElementPath.create(Arrays.asList(namedElement.getName()));
        }
        NLConfig config = new NLConfig(DDesignEditorFactory.getInstance().getDefaultNLConfiguration());
        config.setFlowShowBoundaryConnections(PrefConst.getFlowShowBoundaryConnections());
        config.setBreadcrumbInput(new BreadcrumbInput(project, segments, DiagramBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
        String defaultDiagramKind = DVTPlugin.getDefault().getPreferenceStore().getString("designdiagrams.starting_type");
        if (KLayDiagramKind.BLOCK.getName().equals(defaultDiagramKind)) {
            DDesignEditorFactory.getInstance().newBlockDiagram(namedElement, config, instancePath).openEditor();
        } else if (KLayDiagramKind.FLOW.getName().equals(defaultDiagramKind)) {
            DDesignEditorFactory.getInstance().newFlowDiagram(namedElement, config, instancePath).openEditor();
        } else if (KLayDiagramKind.SCHEMATIC.getName().equals(defaultDiagramKind)) {
            DDesignEditorFactory.getInstance().newSchematicDiagram(namedElement, config, instancePath).openEditor();
        }
        return true;
    }

    private ElementPath getPathFromSegments(List<BreadcrumbSegment> segments) {
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        BreadcrumbSegment breadcrumbSegment = segments.get(segments.size() - 1);
        if (breadcrumbSegment == null) {
            return null;
        }
        IRfBreadcrumbElement element = breadcrumbSegment.getElement();
        if (!(element instanceof ElementPath)) {
            return null;
        }
        return ((ElementPath)element).toElaborationForm();
    }

    protected boolean showFSMDiagram(IDVTElementWrapper wrapper, IRfNamedElement namedElement, Class<? extends IRfMethodElement> functionClazz) {
        boolean hiddenFSMTable;
        IRfNamedElement designEnclosingScope = null;
        IRfNamedElement scopeElement = AMenuCommandDelegateUtils.getInstance().getScopeElement(wrapper.getRfElement(IRfNamedElementAndScope.class), false);
        IRfNamedElement iRfNamedElement = designEnclosingScope = scopeElement != null ? (IRfNamedElement)scopeElement.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN) : null;
        if (designEnclosingScope == null) {
            designEnclosingScope = scopeElement != null ? (IRfNamedElement)scopeElement.getEnclosingScope(functionClazz) : null;
        }
        FSMTransitionTableData tableConstructor = !(hiddenFSMTable = DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_transition_table_disabled")) ? new FSMTransitionTableData() : null;
        DFSMEditorFactory.newFSMDiagram((IRfFieldElement)namedElement, designEnclosingScope, tableConstructor, FSMDiagramConfiguration.getDefault()).openEditor();
        return true;
    }

    @Override
    public boolean showInFactoryOverrides(IDVTElementWrapper wrapper) {
        return false;
    }

    @Override
    public boolean canShowUsages(IDVTElementWrapper wrapper) {
        return wrapper.getProject() != null && this.canShowUsages(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowDesignHierarchy(IDVTElementWrapper wrapper) {
        return wrapper.getProject() != null && this.canShowDesignHierarchy(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowInFactoryOverrides(IDVTElementWrapper wrapper) {
        return false;
    }

    @Override
    public boolean canShowTypeHierarchy(IDVTElementWrapper wrapper) {
        if (wrapper.getRfElement() instanceof IXXVMRegBlock) {
            return false;
        }
        return wrapper.getProject() != null && this.canShowHierarchy(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowDiagram(IDVTElementWrapper wrapper, String viewID) {
        if (wrapper.getProject() == null) {
            return false;
        }
        if ("ro.amiq.dvt.ui.views.FactoryOverridesView".equals(viewID)) {
            return false;
        }
        return "ro.amiq.dvt.ui.views.VerificationHierarchyView".equals(viewID) ? this.canShowComponentDiagram(wrapper) : this.canShowDiagram(wrapper);
    }

    @Override
    public boolean canCopyInView(IDVTElementWrapper wrapper) {
        return wrapper.getProject() != null && this.canCopyInView(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowUVMSequenceTree(IDVTElementWrapper wrapper) {
        return wrapper.getProject() != null && this.canShowUVMSequenceTree(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowConstraints(IDVTElementWrapper wrapper, String viewID) {
        if (wrapper.getRfElement() instanceof IXXVMRegBlock) {
            return false;
        }
        return this.canShowConstraints(this.getNamedElement(wrapper), !"ro.amiq.dvt.ui.views.TypesView".equals(viewID));
    }

    @Override
    public boolean canShowInstances(IDVTElementWrapper wrapper) {
        return this.canShowInstances(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowInstancesInDH(IDVTElementWrapper wrapper) {
        return this.canShowInstances(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowAllInstancesInDH(IDVTElementWrapper wrapper) {
        IProject project = wrapper.getProject();
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return false;
        }
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (namedElement instanceof IRfInstanceElement) {
            Object treePath = wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
            if (!(treePath instanceof TreePath)) {
                return false;
            }
            ElementPath elementPath = ElementPath.from(((TreePath)treePath).toString("."), ".");
            ELInstance elInstance = memory.instanceFor(elementPath);
            if (elInstance == null) {
                return false;
            }
            namedElement = elInstance.getBinding(false);
        }
        return this.canShowInstances(namedElement);
    }

    @Override
    public boolean canShowReaders(IDVTElementWrapper wrapper) {
        if (wrapper.getRfElement() instanceof IXXVMRegBlock) {
            return false;
        }
        return this.canShowReaders(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowWriters(IDVTElementWrapper wrapper) {
        if (wrapper.getRfElement() instanceof IXXVMRegBlock) {
            return false;
        }
        return this.canShowWriters(this.getNamedElement(wrapper));
    }

    @Override
    public boolean canShowCallHierarchy(IDVTElementWrapper wrapper) {
        return wrapper.getProject() != null && this.canShowCallHierarchy(this.getNamedElement(wrapper));
    }

    public boolean canShowInstances(IRfNamedElement namedElement) {
        return RfSearchUtils.isInstantiable(namedElement);
    }
}

