/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;

public class AMenuCommandDelegateUtils {
    private static AMenuCommandDelegateUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMenuCommandDelegateUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new AMenuCommandDelegateUtils();
            }
        }
        return INSTANCE;
    }

    public BreadcrumbInput getBreadcrumbInput(IDVTBreadcrumbHost editor) {
        return AbstractBreadcrumbUtils.getBreadcrumbInput(DHBreadcrumbViewer.class, editor);
    }

    public IRfNamedElement getNamedElement(IProject project, IRfNamedElement namedElement, List<BreadcrumbSegment> segments) {
        ELManager manager = RfMixedLangManager.getInstance().getELManager(project);
        if (manager == null) {
            return namedElement;
        }
        if (segments == null || segments.isEmpty()) {
            return namedElement;
        }
        IRfBreadcrumbElement element = segments.get(segments.size() - 1).getElement();
        if (!(element instanceof ElementPath)) {
            return namedElement;
        }
        ELInstance instanceFor = manager.getMemory().instanceFor(((ElementPath)element).toElaborationForm());
        if (instanceFor == null) {
            return namedElement;
        }
        if (!(namedElement instanceof IRfDesignElement)) {
            return namedElement;
        }
        namedElement = instanceFor.getDescription();
        if (namedElement instanceof DummyInstance) {
            namedElement = ((DummyInstance)namedElement).design;
        }
        return namedElement;
    }

    public List<BreadcrumbSegment> getDHBreadcrumbFromEditor(IEditorPart activeEditor, IRfNamedElement namedElement, IRfNamedElement instanceToAppend, boolean fromDHBreadcrumb) {
        IProject project;
        BreadcrumbInput breadcrumbInput;
        IDVTBreadcrumbHost dvtEditor;
        block9: {
            block8: {
                block7: {
                    try {
                        if (activeEditor instanceof IDVTBreadcrumbHost) break block7;
                        return null;
                    }
                    catch (Throwable e) {
                        DVTLogger.INSTANCE.logError(e);
                        return null;
                    }
                }
                dvtEditor = (IDVTBreadcrumbHost)activeEditor;
                breadcrumbInput = AMenuCommandDelegateUtils.getInstance().getBreadcrumbInput(dvtEditor);
                if (breadcrumbInput != null) break block8;
                return null;
            }
            project = dvtEditor.getProject();
            if (project != null) break block9;
            return null;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (fromDHBreadcrumb) {
            return memory == null ? breadcrumbInput.getSegmentsUpTo(namedElement) : breadcrumbInput.getDesignSegmentsUpTo(namedElement);
        }
        AbstractBreadcrumbUtils breadcrumbUtils = dvtEditor.getBreadcrumbUtils(DHBreadcrumbViewer.class);
        IRfBreadcrumbElement elemInBc = DHBreadcrumbUtils.getElemInBc(breadcrumbInput, namedElement, breadcrumbUtils);
        if (elemInBc != null) {
            return breadcrumbInput.getSegmentsUpTo(elemInBc);
        }
        return DHBreadcrumbUtils.computeBCSegmentsForInstance(dvtEditor, breadcrumbInput, memory, instanceToAppend);
    }

    public IRfNamedElement getScopeElement(IRfNamedElementAndScope rfElement, boolean forBC) {
        if (rfElement == null) {
            return null;
        }
        IRfScopeElement scope = rfElement.getScope();
        if (scope instanceof IRfDefElement) {
            return ((IRfDefElement)((Object)scope)).getNamedElement();
        }
        if (forBC && scope instanceof IRfNamedElement) {
            return (IRfNamedElement)scope;
        }
        return null;
    }
}

