/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class AddResourceToBuildConfigHandler
extends AbstractHandler {
    private static final String NEWLINE = System.getProperty("line.separator");
    protected List<IResource> fResources = new ArrayList<IResource>();
    protected IProject fProject;
    protected String fErrorMessage;
    protected IEvaluationContext fEvaluationContext;
    protected String fDirective;
    protected int fBuildConfigProperty;
    protected String fNature;
    protected AddResourceContext fContext;
    protected String fAddedElements;
    protected String fBuildConfigPropertyName;

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (evaluationContext instanceof IEvaluationContext) {
            this.fEvaluationContext = (IEvaluationContext)evaluationContext;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isEnabled(String nature, AddResourceContext context) {
        try {
            if (this.fEvaluationContext == null) {
                return false;
            }
            this.checkSelection(context);
            if (this.fProject == null || !this.fProject.hasNature(nature)) {
                return false;
            }
            File dotDvtDir = new File(this.fProject.getLocation().toFile(), ".dvt");
            if (!dotDvtDir.exists()) {
                return false;
            }
            if (this.fResources.isEmpty()) {
                return false;
            }
            if (context == AddResourceContext.FOLDER) {
                for (IResource resource : this.fResources) {
                    if (resource instanceof IFolder) continue;
                    return false;
                }
            } else if (context == AddResourceContext.FILE) {
                for (IResource resource : this.fResources) {
                    if (!(resource instanceof IFolder) && !(resource instanceof IProject)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block13: {
            block12: {
                this.fEvaluationContext = (IEvaluationContext)event.getApplicationContext();
                this.checkSelection(this.fContext);
                if (this.fErrorMessage != null) {
                    this.popError(this.fBuildConfigPropertyName);
                    return null;
                }
                if (this.fResources != null && !this.fResources.isEmpty() && this.fProject != null) break block12;
                return null;
            }
            if (this.fProject.hasNature("ro.amiq.vlogdt.VlogNature")) break block13;
            return null;
        }
        try {
            int status;
            ArrayList<BuildConfigProperty> allProperties = new ArrayList<BuildConfigProperty>();
            ArrayList<String> existingItems = new ArrayList<String>();
            ArrayList<String> duplicates = new ArrayList<String>();
            List<BuildConfigProperty> activeBuildConfigCompactedCachedInfo = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(this.fProject);
            if (activeBuildConfigCompactedCachedInfo != null) {
                allProperties.addAll(activeBuildConfigCompactedCachedInfo);
            }
            for (BuildConfigProperty p : allProperties) {
                if (p.getKind() != this.fBuildConfigProperty) continue;
                existingItems.add(p.getValue());
            }
            String activeBuildConfig = String.valueOf(BuildConfigManager.getActiveBuildConfigName(this.fProject)) + ".build";
            File activeBuildConfigFile = new File(this.fProject.getLocation().toFile(), ".dvt/" + activeBuildConfig);
            StringBuilder sb = new StringBuilder();
            for (IResource resource : this.fResources) {
                String filePath = DVTFileUtils.getInstance().resolveAutoLinkPath(resource).toOSString();
                if (filePath == null || filePath.isEmpty()) continue;
                if (!existingItems.contains(filePath)) {
                    sb.append(String.valueOf(NEWLINE) + this.fDirective + (DVTFileUtils.getInstance().isLinked(resource) ? filePath : resource.getProjectRelativePath().toOSString()));
                    continue;
                }
                duplicates.add(resource.getProjectRelativePath().toOSString());
            }
            if (!duplicates.isEmpty()) {
                this.popDuplicates(duplicates, this.fAddedElements, this.fBuildConfigPropertyName);
            }
            if (sb.length() > 0 && (status = this.applyChangesFromUserInput(activeBuildConfigFile, sb.toString())) == 0) {
                this.fProject.getProject().getFolder(".dvt").getFile(activeBuildConfigFile.getName()).refreshLocal(1, null);
                this.popTriggerRebuild(this.fBuildConfigPropertyName);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    protected int applyChangesFromUserInput(File activeBuildConfigFile, String content) {
        int status = DVTFileUtils.getInstance().writeStringToFileWithCheckout(this.fProject, activeBuildConfigFile, content);
        if (status == 8) {
            throw new OperationCanceledException();
        }
        if (status == 4) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Checkout Error", (String)("Unable to check out " + activeBuildConfigFile.getAbsolutePath()));
        }
        return status;
    }

    protected void popTriggerRebuild(String buildConfigPropertyName) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Add as " + buildConfigPropertyName + " changed!", null, "You added a new " + buildConfigPropertyName + " to your project. " + "It is recommended to rebuild for refreshing dictionary, errors etc.", 2, new String[]{"Rebuild Now", "Later"}, 0);
        if (dialog.open() == 0) {
            DVTBuildUtils.runInternalBuilder(this.fProject);
        }
    }

    protected void popDuplicates(final List<String> duplicates, String addedElements, String buildConfigProperty) {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Existing " + buildConfigProperty, null, "The following " + addedElements + " you tried to add are already set as " + buildConfigProperty + ":", 2, new String[]{"OK"}, 0){

            protected Control createCustomArea(Composite parent) {
                parent.setLayout((Layout)new GridLayout());
                org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2560);
                GridData layoutData = new GridData(4, 4, true, true);
                layoutData.heightHint = 100;
                list.setLayoutData((Object)layoutData);
                list.setItems(duplicates.toArray(new String[duplicates.size()]));
                list.setSelection(new String[0]);
                return parent;
            }
        }.open();
    }

    protected void popError(String buildConfigPropertyName) {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Add as " + buildConfigPropertyName + " Error", null, this.fErrorMessage, 1, new String[]{"OK"}, 0).open();
    }

    public void checkSelection(AddResourceContext context) {
        try {
            this.fResources.clear();
            this.fProject = null;
            this.fErrorMessage = null;
            ISelection selection = DVTPlugin.getSelectionManager().getLastSelection();
            if (selection instanceof IStructuredSelection) {
                Object[] elements;
                Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!(context == AddResourceContext.FOLDER ? !(element instanceof IFolder) || element instanceof IProject : (context == AddResourceContext.FILE ? !(element instanceof IResource) || element instanceof IProject || element instanceof IFolder : !(element instanceof IResource) || element instanceof IProject))) {
                        IResource resource = (IResource)element;
                        if (this.fProject == null) {
                            this.fProject = resource.getProject();
                        } else if (!this.fProject.getName().equals(resource.getProject().getName())) {
                            this.fErrorMessage = "You have to select resources from a single project!";
                            return;
                        }
                        IPath relativePath = resource.getProjectRelativePath();
                        if (!(relativePath.lastSegment().equals("DVT Auto-Linked") || resource.isVirtual() && !relativePath.segment(0).equals("DVT Auto-Linked") || Platform.getOS().equals("win32") && relativePath.segment(0).equals("DVT Auto-Linked") && resource instanceof IFolder)) {
                            this.fResources.add((IResource)element);
                        }
                    }
                    ++n2;
                }
            } else {
                IResource res = DVTPlugin.getSelectionManager().getLastSelectedResource();
                if (res == null || res instanceof IProject || context == AddResourceContext.FOLDER && !(res instanceof IFolder) || context == AddResourceContext.FILE && res instanceof IFolder) {
                    this.fErrorMessage = "Selection is not valid!";
                    return;
                }
                this.fResources.add(res);
                this.fProject = res.getProject();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected static enum AddResourceContext {
        RESOURCE,
        FILE,
        FOLDER;

    }
}

