/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.AddResourceToBuildConfigHandler;
import ro.amiq.dvt.utils.DVTFileUtils;

public class AddToTestFilesHandler
extends AddResourceToBuildConfigHandler {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TEST_FILE_DIRECTIVE = "+dvt_test+";
    private boolean fShouldRebuild = false;

    public void initialize() {
        this.fNature = "ro.amiq.edt.enature";
        this.fContext = AddResourceToBuildConfigHandler.AddResourceContext.FILE;
        this.fAddedElements = "files";
        this.fBuildConfigPropertyName = "test file";
    }

    public boolean isEnabled() {
        this.initialize();
        return super.isEnabled(this.fNature, this.fContext);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        int status;
        ArrayList<String> duplicates;
        ArrayList<String> alsoTopFiles;
        block21: {
            block20: {
                this.fEvaluationContext = (IEvaluationContext)event.getApplicationContext();
                this.initialize();
                super.checkSelection(this.fContext);
                if (this.fErrorMessage != null) {
                    this.popError(this.fBuildConfigPropertyName);
                    return null;
                }
                alsoTopFiles = new ArrayList<String>();
                duplicates = new ArrayList<String>();
                status = 0;
                if (this.fResources != null && !this.fResources.isEmpty() && this.fProject != null) break block20;
                return null;
            }
            if (this.fProject.hasNature("ro.amiq.edt.enature") || this.fProject.hasNature("ro.amiq.slndt.slnnature") || this.fProject.hasNature("ro.amiq.msdldt.msdlnature") || this.fProject.hasNature("ro.amiq.pssdt.pssnature")) break block21;
            return null;
        }
        try {
            this.fShouldRebuild = false;
            File dotDvtDir = new File(this.fProject.getLocation().toFile(), ".dvt");
            if (!dotDvtDir.exists()) {
                dotDvtDir.mkdir();
            }
            ArrayList<BuildConfigProperty> allProperties = new ArrayList<BuildConfigProperty>();
            ArrayList<String> existingTestFiles = new ArrayList<String>();
            ArrayList<String> existingTopFiles = new ArrayList<String>();
            List<BuildConfigProperty> activeBuildConfigCompactedCachedInfo = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(this.fProject);
            if (activeBuildConfigCompactedCachedInfo != null) {
                allProperties.addAll(activeBuildConfigCompactedCachedInfo);
            }
            for (BuildConfigProperty p : allProperties) {
                if (p.getKind() == 0 && !p.hasAttribute("ATTRIBUTE_TEST_FILE")) {
                    existingTopFiles.add(p.getValue());
                    continue;
                }
                if (p.getKind() != 0 || !p.hasAttribute("ATTRIBUTE_TEST_FILE")) continue;
                existingTestFiles.add(p.getValue());
            }
            String activeBuildConfig = String.valueOf(BuildConfigManager.getActiveBuildConfigName(this.fProject)) + ".build";
            File activeBuildConfigFile = new File(this.fProject.getLocation().toFile(), ".dvt/" + activeBuildConfig);
            StringBuilder content = new StringBuilder();
            for (IResource resource : this.fResources) {
                String filePath = DVTFileUtils.getInstance().resolveAutoLinkPath(resource).toOSString();
                if (filePath == null || filePath.isEmpty()) continue;
                if (existingTestFiles.contains(filePath)) {
                    duplicates.add(resource.getProjectRelativePath().toOSString());
                    continue;
                }
                if (existingTopFiles.contains(filePath)) {
                    alsoTopFiles.add(resource.getProjectRelativePath().toOSString());
                    continue;
                }
                String toAdd = String.valueOf(NEWLINE) + TEST_FILE_DIRECTIVE + (DVTFileUtils.getInstance().isLinked(resource) ? filePath : resource.getProjectRelativePath().toOSString());
                if (resource instanceof IFolder) {
                    toAdd = String.valueOf(toAdd) + "/**/*";
                }
                content.append(toAdd);
                this.fShouldRebuild = true;
            }
            status = this.applyChangesFromUserInput(activeBuildConfigFile, content.toString());
            if (status == 0) {
                this.fProject.getProject().getFolder(".dvt").getFile(activeBuildConfigFile.getName()).refreshLocal(1, null);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (status != 0) {
            return null;
        }
        if (!duplicates.isEmpty()) {
            this.popDuplicates(duplicates, this.fAddedElements, this.fBuildConfigPropertyName);
        }
        if (!alsoTopFiles.isEmpty()) {
            this.popTestFiles(alsoTopFiles);
        }
        if (this.fShouldRebuild) {
            this.popTriggerRebuild(this.fBuildConfigPropertyName);
        } else {
            this.popNothingToAdd();
        }
        return null;
    }

    private void popTestFiles(final List<String> addedTopFiles) {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Top File Added As Test File", null, "The following files you tried to add are already set as Top Files:", 1, new String[]{"OK"}, 0){

            protected Control createCustomArea(Composite parent) {
                parent.setLayout((Layout)new GridLayout());
                org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2560);
                GridData layoutData = new GridData(4, 4, true, true);
                layoutData.heightHint = 100;
                list.setLayoutData((Object)layoutData);
                list.setItems(addedTopFiles.toArray(new String[addedTopFiles.size()]));
                list.setSelection(new String[0]);
                return parent;
            }
        }.open();
    }

    private void popNothingToAdd() {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Add Test Files Error", null, "There were no files eligible for new Test Files in the selection you made.", 2, new String[]{"OK"}, 0).open();
    }
}

