/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.guifilters.GUIFiltersHandler;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.views.DVTViewManager;

public class CategorySelectAction
extends Action {
    private Composite fParent;
    private IPreferenceStore fStore;
    private Map<String, String> fFieldNames = new LinkedHashMap<String, String>();
    private LanguageKind fLanguageKind;
    private String fTitle;
    private String fPreferenceName;

    public CategorySelectAction(Composite parent, IPreferenceStore store, Map<String, String> fieldNames, String title, LanguageKind languageKind, String preferenceName) {
        super("&Filters...");
        this.setImageDescriptor(DVTImages.FILTER);
        this.fParent = parent;
        this.fStore = store;
        this.fFieldNames = fieldNames;
        this.fLanguageKind = languageKind;
        this.fPreferenceName = preferenceName;
        this.fTitle = title;
    }

    public void run() {
        StatusDialog dialog = new StatusDialog(this.fParent.getShell()){
            private CheckboxTableViewer fCheckBoxList;

            protected Control createDialogArea(Composite parent) {
                Composite container = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                container.setLayout((Layout)layout);
                container.setLayoutData((Object)new GridData(4, 4, true, true));
                container.setFont(parent.getFont());
                Label info = new Label(container, 16384);
                info.setText("S&elect the elements to include on the view:");
                this.fCheckBoxList = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
                this.fCheckBoxList.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                this.fCheckBoxList.setLabelProvider(this.createLabelProvider());
                this.fCheckBoxList.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.fCheckBoxList.setInput(CategorySelectAction.this.fFieldNames.keySet());
                for (Map.Entry<String, String> entry : CategorySelectAction.this.fFieldNames.entrySet()) {
                    String fieldName = entry.getKey();
                    this.fCheckBoxList.setChecked((Object)fieldName, CategorySelectAction.this.fStore.getBoolean(entry.getValue()));
                }
                Composite buttons = new Composite(container, 0);
                GridLayout buttonsLayout = new GridLayout(2, false);
                buttonsLayout.marginWidth = 0;
                buttonsLayout.marginHeight = 0;
                buttons.setLayout((Layout)buttonsLayout);
                buttons.setLayoutData((Object)new GridData(131072, 1024, true, false, 2, 1));
                Button selectAll = new Button(buttons, 0);
                selectAll.setText("Select All");
                selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        for (String fieldName : (this).CategorySelectAction.this.fFieldNames.keySet()) {
                            fCheckBoxList.setChecked((Object)fieldName, true);
                        }
                    }
                });
                Button deselectAll = new Button(buttons, 0);
                deselectAll.setText("Deselect All");
                deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        for (String fieldName : (this).CategorySelectAction.this.fFieldNames.keySet()) {
                            fCheckBoxList.setChecked((Object)fieldName, false);
                        }
                    }
                });
                1.applyDialogFont((Control)container);
                return container;
            }

            private IBaseLabelProvider createLabelProvider() {
                return new LabelProvider(){

                    public Image getImage(Object element) {
                        return null;
                    }

                    public String getText(Object element) {
                        if (element instanceof String) {
                            return (String)element;
                        }
                        return null;
                    }
                };
            }

            protected void okPressed() {
                boolean setValues = false;
                for (Map.Entry<String, String> entry : CategorySelectAction.this.fFieldNames.entrySet()) {
                    String fieldName = entry.getKey();
                    if (this.fCheckBoxList.getChecked((Object)fieldName) == CategorySelectAction.this.fStore.getBoolean(entry.getValue())) continue;
                    CategorySelectAction.this.fStore.setValue(entry.getValue(), this.fCheckBoxList.getChecked((Object)fieldName));
                    setValues = true;
                }
                if (setValues) {
                    if (CategorySelectAction.this.fPreferenceName.equals("outline.prefs_changed")) {
                        DVTPredefinedGUIFilters.putOutlinePredefinedGUIFilter(CategorySelectAction.this.fLanguageKind, CategorySelectAction.this.fStore);
                    }
                    boolean filtering = GUIFiltersHandler.isFilteringEnabled();
                    DVTViewManager.loadGuiFilters(DVTPlugin.getSelectionManager().getLastSelectedProject(), filtering);
                    boolean prev = CategorySelectAction.this.fStore.getBoolean(CategorySelectAction.this.fPreferenceName);
                    CategorySelectAction.this.fStore.firePropertyChangeEvent(CategorySelectAction.this.fPreferenceName, (Object)prev, (Object)true);
                }
                super.okPressed();
            }
        };
        dialog.setTitle(this.fTitle);
        dialog.setHelpAvailable(false);
        dialog.open();
    }
}

