/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.ui.actions.CopyFileInfoKind;
import ro.amiq.dvt.utils.Utils;

public class CopyFileInfoAction
extends TextEditorAction {
    private CopyFileInfoKind fileInfoKind;

    public CopyFileInfoAction(ResourceBundle bundle, String prefix, ITextEditor editor, CopyFileInfoKind kind) {
        super(bundle, prefix, editor);
        this.fileInfoKind = kind;
    }

    public void run() {
        IEditorInput editorInput = this.getTextEditor().getEditorInput();
        IResource file = (IResource)editorInput.getAdapter(IResource.class);
        if (file == null) {
            return;
        }
        String result = null;
        switch (this.fileInfoKind) {
            case COPY_FILE_NAME: {
                result = file.getName();
                break;
            }
            case COPY_FNAME_NO_EXT: {
                result = file.getLocation().removeFileExtension().lastSegment();
                break;
            }
            case COPY_FOLDER_PATH: {
                result = file.getLocation().removeLastSegments(1).toOSString();
                break;
            }
            case COPY_FULL_PATH: {
                result = file.getLocation().toOSString();
                break;
            }
        }
        if (result == null) {
            return;
        }
        Utils.copyToClipboard(result, 3);
    }
}

