/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BCDvtInit;
import ro.amiq.dvt.buildconfig.LanguageElementFileInstance;
import ro.amiq.dvt.model.reflection.views.BCTreeElementWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public class CopyFullPath
extends AbstractHandler {
    private boolean fIsEnabled = false;

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (evaluationContext instanceof IEvaluationContext) {
            this.fIsEnabled = this.getResource((IEvaluationContext)evaluationContext) != null;
        }
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            List<IResource> resources = this.getResource((IEvaluationContext)event.getApplicationContext());
            Map<IResource, IPath> resolvedPaths = DVTFileUtils.getInstance().resolveResourcesPaths(resources);
            StringBuilder result = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<IResource, IPath> entry : resolvedPaths.entrySet()) {
                IResource resource = entry.getKey();
                IPath location = entry.getValue();
                if (location == null) {
                    sb.append(resource.getFullPath()).append('\n');
                    continue;
                }
                String fullPath = location.toOSString();
                if (fullPath == null) continue;
                if (result.length() > 0) {
                    result.append('\n');
                }
                result.append(fullPath);
            }
            if (sb.length() > 0) {
                new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Copy Full Path", null, "The following virtual resources were excluded because the physical path can't be resolved:\n" + sb.toString(), 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
            }
            Utils.copyToClipboard(result.toString(), 3);
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IResource> getResource(IEvaluationContext evaluationContext) {
        ArrayList<IResource> result;
        block9: {
            result = new ArrayList<IResource>();
            try {
                IResource selection;
                String partId;
                Object id = evaluationContext.getVariable("activePartId");
                if (!(id instanceof String) || !(partId = (String)id).equals("org.eclipse.ui.views.ResourceNavigator") && !partId.equals("org.eclipse.ui.navigator.ProjectExplorer") && !partId.equals("ro.amiq.dvt.ui.views.CompileOrderView") && !partId.equals("org.eclipse.search.ui.views.SearchView")) break block9;
                Object variable = evaluationContext.getVariable("selection");
                if (variable != null && variable instanceof IStructuredSelection) {
                    BCTreeElementWrapper wrapper;
                    Object elem = ((IStructuredSelection)variable).getFirstElement();
                    if (elem instanceof BCTreeElementWrapper && ((wrapper = (BCTreeElementWrapper)elem).getRfElement() instanceof LanguageElementFileInstance || wrapper.getRfElement() instanceof BCDvtInit)) {
                        return null;
                    }
                    IStructuredSelection selection2 = (IStructuredSelection)variable;
                    List elements = selection2.toList();
                    if (elements != null && !elements.isEmpty()) {
                        for (Object element : elements) {
                            Object resource;
                            if (element instanceof IResource) {
                                result.add((IResource)element);
                                continue;
                            }
                            if (!(element instanceof IAdaptable) || !((resource = ((IAdaptable)element).getAdapter(IResource.class)) instanceof IResource)) continue;
                            result.add((IResource)resource);
                        }
                    }
                }
                if (result.isEmpty() && (selection = DVTPlugin.getSelectionManager().getLastSelectedResource()) != null) {
                    result.add(selection);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

