/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DVTActionManager {
    private static HashMap<String, ArrayList<IObjectActionDelegate>> fActionDelegates = new HashMap();

    public static void setActionDelegate(String id, IObjectActionDelegate delegate) {
        ArrayList<IObjectActionDelegate> delegates = null;
        if (!fActionDelegates.containsKey(id)) {
            fActionDelegates.put(id, new ArrayList());
        }
        delegates = fActionDelegates.get(id);
        delegates.add(delegate);
    }

    public static boolean isActionEnabled(IAction action, ISelection selection) {
        ArrayList<IObjectActionDelegate> delegates = fActionDelegates.get(action.getId());
        if (delegates == null) {
            return false;
        }
        for (IObjectActionDelegate delegate : delegates) {
            delegate.selectionChanged(action, selection);
            if (!action.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public static void runAction(IAction action) {
        ArrayList<IObjectActionDelegate> delegates = fActionDelegates.get(action.getId());
        if (delegates == null) {
            return;
        }
        for (IObjectActionDelegate delegate : delegates) {
            if (!action.isEnabled()) continue;
            delegate.run(action);
        }
    }

    public static void setActivePart(IAction action, IWorkbenchPart targetPart) {
        ArrayList<IObjectActionDelegate> delegates = fActionDelegates.get(action.getId());
        if (delegates == null) {
            return;
        }
        for (IObjectActionDelegate delegate : delegates) {
            delegate.setActivePart(action, targetPart);
        }
    }

    public static List<IObjectActionDelegate> getDelegates(String id) {
        return fActionDelegates.containsKey(id) ? (List)fActionDelegates.get(id) : new ArrayList(0);
    }

    public static void init() {
    }
}

