/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IResourceSelectionChangeListener;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigBuilder;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigXml;
import ro.amiq.dvt.buildconfig.IBuildConfigChangeListener;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.externaltools.ExternalToolsStoreUtil;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesListener;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.ProjectRebuildHandler;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.ui.views.DVTViewManager;

public enum DynamicBuildButtonsContribution implements IBuildConfigChangeListener,
IResourceSelectionChangeListener,
IWindowListener,
IResourceChangeListener,
IPerspectiveListener
{
    INSTANCE;

    public static final String TOOLBAR_ID = "ro.amiq.dvt.toolbar.Rebuild";
    private Set<IWorkbenchWindow> fWindows = new HashSet<IWorkbenchWindow>();
    private Action fSetCurrentBuildAction;
    private ActionContributionItem fRebuildExternalActionItem;
    private ActionContributionItem fRebuildInternalAction;
    private ActionContributionItem fRebuildTestsInternalAction;

    public void init() {
        this.populateToolbar();
        this.addListeners();
        this.refresh();
    }

    private void populateToolbar() {
        IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
        if (this.fWindows.contains(window)) {
            return;
        }
        this.fWindows.add(window);
        IToolBarManager toolbarManager = DVTUiUtils.getToolbarManager((String)TOOLBAR_ID);
        if (toolbarManager == null) {
            return;
        }
        this.addSetCurrentBuildAction(toolbarManager);
        this.addRebuildAction(toolbarManager);
        this.addRebuildInternalAction(toolbarManager);
        this.addRebuildTestsInternalAction(toolbarManager);
        this.addRebuildExternalAction(toolbarManager);
    }

    private void addListeners() {
        BuildConfigManager.registerBuildConfigChangeListener(this);
        BuildConfigManager.registerBuildConfigChangeListener(LazyResourcesListener.INSTANCE);
        DVTPlugin.getSelectionManager().addResourceSelectionChangeListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    private void addSetCurrentBuildAction(IToolBarManager toolbarManager) {
        this.fSetCurrentBuildAction = new Action(){

            public boolean isHandled() {
                return true;
            }

            public void run() {
                IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                if (selProject == null) {
                    return;
                }
                Menu menu = this.getMenuCreator().getMenu((Control)DVTUiUtils.getActiveWorkbenchWindow().getShell());
                menu.setVisible(true);
            }
        };
        this.fSetCurrentBuildAction.setMenuCreator(new IMenuCreator(){
            Menu fMenu = null;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                final IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                this.fMenu = new Menu(parent);
                this.fMenu.setVisible(true);
                String activeBuildConfig = "";
                List<Object> availableBuildConfigs = new ArrayList();
                if (ro.amiq.dvt.utils.Utils.isAccessibleDVTProject(project)) {
                    activeBuildConfig = BuildConfigManager.getActiveBuildConfigName(project);
                    availableBuildConfigs = BuildConfigManager.getAvailableBuildConfigs(project);
                }
                if (!availableBuildConfigs.isEmpty()) {
                    for (final String buildConfigName : availableBuildConfigs) {
                        MenuItem menuItem = new MenuItem(this.fMenu, 16);
                        menuItem.setText(buildConfigName);
                        if (activeBuildConfig.equals(buildConfigName)) {
                            menuItem.setSelection(true);
                        }
                        menuItem.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                if (!(e.widget instanceof MenuItem)) {
                                    return;
                                }
                                if (!((MenuItem)e.widget).getSelection()) {
                                    return;
                                }
                                DynamicBuildButtonsContribution.this.setActiveBuildConfig(project, buildConfigName);
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                this.widgetSelected(e);
                            }
                        });
                    }
                } else {
                    MenuItem menuItem = new MenuItem(this.fMenu, 0);
                    menuItem.setText("No build configs - click for more info");
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            DVTUiUtils.openHelpPage((String)"Build_Configurations.html");
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                return this.fMenu;
            }

            public void dispose() {
                if (this.fMenu != null) {
                    this.fMenu.dispose();
                }
            }
        });
        this.fSetCurrentBuildAction.setToolTipText("Set Current Build Configuration");
        this.fSetCurrentBuildAction.setText("Set Current Build Configuration");
        this.fSetCurrentBuildAction.setImageDescriptor(DVTImages.SET_ACTIVE_BUILD_CONFIG);
        this.fSetCurrentBuildAction.setEnabled(true);
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)this.fSetCurrentBuildAction);
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolbarManager.add((IContributionItem)actionContributionItem);
    }

    private void setActiveBuildConfig(IProject project, String buildConfigName) {
        this.setActiveBuildConfig(project, buildConfigName, BuildConfigParseMode.NO_PARSE);
    }

    public void setActiveBuildConfig(IProject project, String buildConfigName, BuildConfigParseMode parseMode) {
        if (!BuildConfigXml.load(project).setActiveBuildConfigName(buildConfigName).save()) {
            MessageDialog.openError((Shell)Utils.getActiveShell(), (String)"Failed to save .dvt/build.config.xml", (String)"Unable to save .dvt/build.config.xml.\nPlease check write permissions");
        }
        try {
            if (project != null) {
                project.getFile(".dvt/build.config.xml").refreshLocal(2, null);
            }
        }
        catch (CoreException e1) {
            DVTLogger.INSTANCE.logError((Throwable)e1);
        }
        if (BuildConfigManager.updateActiveBuildConfig(project)) {
            BuildConfigBuilder.refreshActiveBuildConfig(project);
            BuildConfigManager.reapplyIncludeAutoFilters(project, parseMode);
        }
    }

    private void addRebuildAction(IToolBarManager toolbarManager) {
        Action rebuildAction = new Action(){

            public boolean isHandled() {
                return true;
            }

            public void run() {
                IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                if (selProject == null) {
                    return;
                }
                ProjectRebuildHandler.build(new ExecutionEvent(null, new HashMap(), null, null));
            }
        };
        rebuildAction.setMenuCreator(new IMenuCreator(){
            Menu fMenu = null;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                this.fMenu = new Menu(parent);
                this.fMenu.setVisible(true);
                MenuItem rebuildMenuItem = new MenuItem(this.fMenu, 0);
                rebuildMenuItem.setText("Rebuild Project");
                rebuildMenuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                        if (selProject == null) {
                            return;
                        }
                        ProjectRebuildHandler.build(new ExecutionEvent(null, new HashMap(), null, null));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                new MenuItem(this.fMenu, 2);
                MenuItem cleanMenuItem = new MenuItem(this.fMenu, 0);
                cleanMenuItem.setText("Clean Project");
                cleanMenuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                        if (selProject == null) {
                            return;
                        }
                        ProjectRebuildHandler.build(new ExecutionEvent(null, (Map)new HashMap<String, String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.put("ro.amiq.dvt.ui.rebuild.cleanOnly", "true");
                            }
                        }, null, null));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                return this.fMenu;
            }

            public void dispose() {
                if (this.fMenu != null) {
                    this.fMenu.dispose();
                }
            }
        });
        rebuildAction.setToolTipText("Rebuild Project");
        rebuildAction.setText("Rebuild Project");
        rebuildAction.setImageDescriptor(DVTImages.REBUILD_FULL);
        rebuildAction.setEnabled(true);
        toolbarManager.add((IContributionItem)new ActionContributionItem((IAction)rebuildAction));
    }

    private void addRebuildInternalAction(IToolBarManager toolbarManager) {
        Action rebuildInternalAction = new Action(){

            public boolean isHandled() {
                return true;
            }

            public void run() {
                IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                if (selProject == null) {
                    return;
                }
                ProjectRebuildHandler.build(new ExecutionEvent(null, (Map)new HashMap<String, String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put("ro.amiq.dvt.ui.rebuild.kind", "internal");
                    }
                }, null, null));
            }
        };
        rebuildInternalAction.setMenuCreator(new IMenuCreator(){
            Menu fMenu = null;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                this.fMenu = new Menu(parent);
                this.fMenu.setVisible(true);
                MenuItem rebuildMenuItem = new MenuItem(this.fMenu, 0);
                rebuildMenuItem.setText("Rebuild Project (Internal Builder)");
                rebuildMenuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                        if (selProject == null) {
                            return;
                        }
                        ProjectRebuildHandler.build(new ExecutionEvent(null, (Map)new HashMap<String, String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.put("ro.amiq.dvt.ui.rebuild.kind", "internal");
                            }
                        }, null, null));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                new MenuItem(this.fMenu, 2);
                MenuItem cleanMenuItem = new MenuItem(this.fMenu, 0);
                cleanMenuItem.setText("Clean Project");
                cleanMenuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                        if (selProject == null) {
                            return;
                        }
                        ProjectRebuildHandler.build(new ExecutionEvent(null, (Map)new HashMap<String, String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.put("ro.amiq.dvt.ui.rebuild.kind", "internal");
                                this.put("ro.amiq.dvt.ui.rebuild.cleanOnly", "true");
                            }
                        }, null, null));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                return this.fMenu;
            }

            public void dispose() {
                if (this.fMenu != null) {
                    this.fMenu.dispose();
                }
            }
        });
        rebuildInternalAction.setToolTipText("Rebuild Project (Internal Builder)");
        rebuildInternalAction.setText("Rebuild Project (Internal Builder)");
        rebuildInternalAction.setImageDescriptor(DVTImages.REBUILD_INTERNAL);
        rebuildInternalAction.setEnabled(true);
        this.fRebuildInternalAction = new ActionContributionItem((IAction)rebuildInternalAction);
        toolbarManager.add((IContributionItem)this.fRebuildInternalAction);
    }

    private void addRebuildTestsInternalAction(IToolBarManager toolbarManager) {
        Action rebuildInternalAction = new Action(){

            public boolean isHandled() {
                return true;
            }

            public void run() {
                IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                if (selProject == null) {
                    return;
                }
                ProjectRebuildHandler.build(new ExecutionEvent(null, (Map)new HashMap<String, String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put("ro.amiq.dvt.ui.rebuild.kind", "tests_only");
                    }
                }, null, null));
            }
        };
        rebuildInternalAction.setToolTipText("Rebuild e Language Tests");
        rebuildInternalAction.setText("Rebuild e Language Tests");
        rebuildInternalAction.setImageDescriptor(DVTImages.REBUILD_TESTS);
        rebuildInternalAction.setEnabled(true);
        this.fRebuildTestsInternalAction = new ActionContributionItem((IAction)rebuildInternalAction);
        toolbarManager.add((IContributionItem)this.fRebuildTestsInternalAction);
    }

    private void addRebuildExternalAction(IToolBarManager toolbarManager) {
        Action rebuildExternalAction = new Action(){

            public boolean isHandled() {
                return true;
            }

            public void run() {
                IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                if (selProject == null) {
                    return;
                }
                ProjectRebuildHandler.rebuildExternalWithArgs(selProject, new HashMap<String, String>());
            }
        };
        rebuildExternalAction.setMenuCreator(new IMenuCreator(){
            Menu fMenu = null;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                final IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                this.fMenu = new Menu(parent);
                this.fMenu.setVisible(true);
                List<Object> availableBuildConfigs = new ArrayList();
                if (ro.amiq.dvt.utils.Utils.isAccessibleDVTProject(project)) {
                    availableBuildConfigs = ExternalToolsStoreUtil.getBuilderConfigurations(project);
                }
                if (availableBuildConfigs != null && !availableBuildConfigs.isEmpty()) {
                    for (IExternalToolsConfiguration iExternalToolsConfiguration : availableBuildConfigs) {
                        MenuItem menuItem = new MenuItem(this.fMenu, 8);
                        menuItem.setText(iExternalToolsConfiguration.getName());
                        menuItem.setData((Object)iExternalToolsConfiguration);
                        menuItem.setEnabled(iExternalToolsConfiguration.getEnable());
                        menuItem.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                try {
                                    if (!(e.widget instanceof MenuItem)) {
                                        return;
                                    }
                                    MenuItem selectedtem = (MenuItem)e.widget;
                                    Object data = selectedtem.getData();
                                    IExternalToolsConfiguration selectedConf = null;
                                    if (data instanceof IExternalToolsConfiguration) {
                                        selectedConf = (IExternalToolsConfiguration)data;
                                    }
                                    if (selectedConf == null) {
                                        return;
                                    }
                                    HashMap<String, String> args = new HashMap<String, String>();
                                    args.put("configurations", selectedConf.getName());
                                    ProjectRebuildHandler.rebuildExternalWithArgs(project, args);
                                }
                                catch (Exception e2) {
                                    DVTLogger.INSTANCE.logError((Throwable)e2);
                                }
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                this.widgetSelected(e);
                            }
                        });
                    }
                    new MenuItem(this.fMenu, 2);
                }
                if (availableBuildConfigs != null && availableBuildConfigs.size() > 1) {
                    MenuItem menuItem = new MenuItem(this.fMenu, 0);
                    menuItem.setText("All External Builders");
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            ProjectRebuildHandler.rebuildExternalWithArgs(project, new HashMap<String, String>());
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                    new MenuItem(this.fMenu, 2);
                }
                MenuItem menuItem = new MenuItem(this.fMenu, 0);
                menuItem.setText("Clean Project (External Builders)");
                menuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                        if (selProject == null) {
                            return;
                        }
                        ProjectRebuildHandler.build(new ExecutionEvent(null, (Map)new HashMap<String, String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.put("ro.amiq.dvt.ui.rebuild.kind", "external");
                                this.put("ro.amiq.dvt.ui.rebuild.cleanOnly", "true");
                            }
                        }, null, null));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                if (project != null) {
                    new MenuItem(this.fMenu, 2);
                    MenuItem configure = new MenuItem(this.fMenu, 0);
                    configure.setText("Configure...");
                    configure.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            IProject selProject = DynamicBuildButtonsContribution.this.getLastSelectedProject();
                            if (selProject == null) {
                                return;
                            }
                            PreferenceDialog pref = PreferencesUtil.createPropertyDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IAdaptable)selProject, (String)"ro.amiq.dvt.externaltools.ui.BuilderPropertyPage", null, null);
                            if (pref != null) {
                                pref.open();
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                return this.fMenu;
            }

            public void dispose() {
                if (this.fMenu != null) {
                    this.fMenu.dispose();
                }
            }
        });
        rebuildExternalAction.setToolTipText("Rebuild Project (External Builders)");
        rebuildExternalAction.setText("Rebuild Project (External Builders)");
        rebuildExternalAction.setImageDescriptor(DVTImages.REBUILD_EXTERNAL);
        rebuildExternalAction.setEnabled(true);
        this.fRebuildExternalActionItem = new ActionContributionItem((IAction)rebuildExternalAction);
        toolbarManager.add((IContributionItem)this.fRebuildExternalActionItem);
    }

    private void refresh() {
        IPerspectiveDescriptor perspective;
        this.fSetCurrentBuildAction.setEnabled(false);
        IProject lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
        this.fSetCurrentBuildAction.setEnabled(lastSelectedProject == null || lastSelectedProject.isAccessible());
        if (lastSelectedProject != null && BuildConfigManager.hasActiveBuildConfig(lastSelectedProject)) {
            this.fSetCurrentBuildAction.setText(" " + BuildConfigManager.getActiveBuildConfigName(lastSelectedProject) + " ");
        } else {
            this.fSetCurrentBuildAction.setText("N/A");
        }
        this.fRebuildTestsInternalAction.setVisible(lastSelectedProject != null && lastSelectedProject.isAccessible() && DVTNature.projectHasNature(lastSelectedProject, LanguageKind.E.NATURE_ID));
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage != null && (perspective = activePage.getPerspective()) != null) {
            String perspectiveID = perspective.getId();
            boolean isVisible = !perspectiveID.equals("ro.amiq.dvt.ui.perspectives.DVTSlimPerspective") && !perspectiveID.equals("ro.amiq.dvt.debug.ui.perspectives.DebugPerspective");
            this.fRebuildExternalActionItem.setVisible(isVisible);
            this.fRebuildInternalAction.setVisible(isVisible);
        }
        DVTUiUtils.redrawToolbarInCoolbar((String)TOOLBAR_ID);
    }

    private void asyncRefresh(final boolean clearViews) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (clearViews) {
                    DVTViewManager.getInstanceByCurrentWorkbenchWindow().clearAllViews();
                }
                DynamicBuildButtonsContribution.this.refresh();
            }
        });
    }

    private IProject getLastSelectedProject() {
        IProject lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (ro.amiq.dvt.utils.Utils.isAccessibleDVTProject(lastSelectedProject)) {
            return lastSelectedProject;
        }
        return ProjectSelectionDialog.selectProject();
    }

    @Override
    public void buildConfigListenerChanged(IProject project, String oldConfigName, String newConfigName) {
        this.asyncRefresh(true);
    }

    @Override
    public void resourceSelectionChanged(IResource resource) {
        this.asyncRefresh(false);
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.populateToolbar();
        this.asyncRefresh(false);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.addPerspectiveListener((IPerspectiveListener)this);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DVTPlugin.getSelectionManager().addResourceSelectionChangeListener(INSTANCE);
                DynamicBuildButtonsContribution.this.populateToolbar();
                DynamicBuildButtonsContribution.this.refresh();
            }
        });
    }

    public void windowClosed(final IWorkbenchWindow window) {
        window.removePerspectiveListener((IPerspectiveListener)this);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DVTPlugin.getSelectionManager().removeResourceSelectionChangeListener(window, INSTANCE);
            }
        });
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta == null) {
                            return false;
                        }
                        if (delta.getResource() instanceof IProject && delta.getFlags() == 16384) {
                            DynamicBuildButtonsContribution.this.asyncRefresh(false);
                            return false;
                        }
                        return delta.getResource() instanceof IWorkspaceRoot;
                    }
                });
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.refresh();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId != null && !changeId.equals("editorClose")) {
            this.refresh();
        }
    }
}

