/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.AddResourceToBuildConfigHandler;
import ro.amiq.dvt.utils.DVTFileUtils;

public class IgnoreFilesHandler
extends AddResourceToBuildConfigHandler {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String IGNORE_DIRECTIVE = "+dvt_skip_compile+";
    private static final String PROJECT_LOC = "$DVT_PROJECT_LOC" + File.separator;

    public void initialize() {
        this.fContext = AddResourceToBuildConfigHandler.AddResourceContext.RESOURCE;
        this.fAddedElements = "files";
        this.fBuildConfigPropertyName = "ignore file";
    }

    public boolean isEnabled() {
        if (this.fEvaluationContext == null) {
            return false;
        }
        this.initialize();
        this.checkSelection(this.fContext);
        return !this.fResources.isEmpty();
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            block9: {
                this.fEvaluationContext = (IEvaluationContext)event.getApplicationContext();
                this.initialize();
                this.checkSelection(this.fContext);
                if (this.fErrorMessage != null) {
                    this.popError(this.fBuildConfigPropertyName);
                    return null;
                }
                if (this.fResources != null && !this.fResources.isEmpty() && this.fProject != null) break block9;
                return null;
            }
            if (this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature") || this.fProject.hasNature("ro.amiq.edt.enature") || this.fProject.hasNature("ro.amiq.slndt.slnnature") || this.fProject.hasNature("ro.amiq.msdldt.msdlnature") || this.fProject.hasNature("ro.amiq.pssdt.pssnature") || this.fProject.hasNature("ro.amiq.vlogdt.VlogNature")) break block10;
            return null;
        }
        try {
            File dotDvtDir = new File(this.fProject.getLocation().toFile(), ".dvt");
            if (!dotDvtDir.exists()) {
                dotDvtDir.mkdir();
            }
            String activeBuildConfig = String.valueOf(BuildConfigManager.getActiveBuildConfigName(this.fProject)) + ".build";
            File activeBuildConfigFile = new File(this.fProject.getLocation().toFile(), ".dvt/" + activeBuildConfig);
            StringBuilder sb = new StringBuilder();
            for (IResource resource : this.fResources) {
                String filePath = DVTFileUtils.getInstance().resolveAutoLinkPath(resource).toOSString();
                if (filePath == null || filePath.isEmpty()) continue;
                sb.append(String.valueOf(NEWLINE) + IGNORE_DIRECTIVE + (DVTFileUtils.getInstance().isLinked(resource) ? filePath : String.valueOf(PROJECT_LOC) + resource.getProjectRelativePath().toOSString()) + (resource instanceof IFolder ? String.valueOf(File.separator) + "*" : ""));
            }
            int status = this.applyChangesFromUserInput(activeBuildConfigFile, sb.toString());
            if (status == 0) {
                this.fProject.getProject().getFolder(".dvt").getFile(activeBuildConfigFile.getName()).refreshLocal(1, null);
                this.popTriggerRebuild(this.fBuildConfigPropertyName);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }
}

