/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.markers.MarkerItem;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.IMacroTraceListener;
import ro.amiq.dvt.ui.actions.MacroTraceActionManager;

public class MacroTraceActionDelegate
implements IViewActionDelegate {
    private String fError;
    private String fPluginID;
    private String fProjectName;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.fError == null || this.fPluginID == null || this.fProjectName == null) {
            return;
        }
        IMacroTraceListener listener = MacroTraceActionManager.getInstance().getListener(this.fPluginID);
        if (listener == null) {
            return;
        }
        listener.notifyMacroTraceError(this.fError, this.fProjectName);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        block10: {
            try {
                action.setEnabled(false);
                this.fError = null;
                if (selection.isEmpty()) {
                    return;
                }
                if (!(selection instanceof StructuredSelection)) break block10;
                Object element = ((StructuredSelection)selection).getFirstElement();
                IMarker marker = null;
                if (element instanceof IMarker) {
                    marker = (IMarker)element;
                } else {
                    try {
                        if (element instanceof MarkerItem) {
                            marker = ((MarkerItem)element).getMarker();
                        }
                    }
                    catch (Exception exception) {}
                }
                if (marker == null) {
                    return;
                }
                this.fError = marker.getAttribute("ro.amiq.dvt.ui.editor.MacroStackTrace", null);
                this.fPluginID = marker.getAttribute("ro.amiq.dvt.ui.editor.MacroPluginID", null);
                this.fProjectName = marker.getAttribute("ro.amiq.dvt.ui.editor.MacroProjectName", null);
                if (this.fError == null || this.fPluginID == null) {
                    return;
                }
                action.setEnabled(true);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

