/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.IMenuCommandDelegate;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class MenuCommandDelegatesManager {
    private static final String MENU_COMMAND_DELEGATES_EXTENSION_ID = "ro.amiq.dvt.viewsContextMenuCommandDelegates";
    private static List<IMenuCommandDelegate> MENU_COMMAND_DELEGATES;

    public static IMenuCommandDelegate getCommandDelegate(IDVTElementWrapper wrapper) {
        if (MENU_COMMAND_DELEGATES == null) {
            MenuCommandDelegatesManager.readExtensions();
        }
        for (IMenuCommandDelegate contributor : MENU_COMMAND_DELEGATES) {
            if (!contributor.canHandle(wrapper)) continue;
            return contributor;
        }
        return null;
    }

    private static synchronized void readExtensions() {
        if (MENU_COMMAND_DELEGATES != null) {
            return;
        }
        MENU_COMMAND_DELEGATES = new ArrayList<IMenuCommandDelegate>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(MENU_COMMAND_DELEGATES_EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement i = iConfigurationElementArray[n2];
            try {
                Object j = i.createExecutableExtension("class");
                if (j instanceof IMenuCommandDelegate) {
                    IMenuCommandDelegate currentExtension = (IMenuCommandDelegate)j;
                    MENU_COMMAND_DELEGATES.add(currentExtension);
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n2;
        }
    }

    public static List<IMenuCommandDelegate> testGetAllCommandDelegate() {
        if (MENU_COMMAND_DELEGATES == null) {
            MenuCommandDelegatesManager.readExtensions();
        }
        return new ArrayList<IMenuCommandDelegate>(MENU_COMMAND_DELEGATES);
    }
}

