/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTFileUtils;

public class OpenFileAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] resources;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        FileDialog dialog = new FileDialog(activeShell);
        dialog.setText("Open File");
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && (resources = this.getSelectedResources((IStructuredSelection)sel)).length > 0 && resources[0].isVirtual() && resources[0] instanceof IFolder) {
            IPath containerPath = DVTFileUtils.getInstance().resolveAutoLinkPath(resources[0]);
            dialog.setFilterPath(containerPath.toOSString());
            IProject project = resources[0].getProject();
            String fileFullName = dialog.open();
            if (fileFullName == null) {
                return null;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, fileFullName, "createResource");
            if (file == null || !file.exists() || file.getLocation() == null || !file.isLinked()) {
                try {
                    IPath filePath = Path.fromOSString((String)fileFullName);
                    DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
                    try {
                        file = DVTAutoLinkManager.getInstance().createAutoLink(project, filePath, BuildConfigManager.getAutoLinkedRoots(project), null, false);
                        DVTAutoLinkManager.getInstance().updateProjectDescription(project);
                    }
                    finally {
                        DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
                    }
                    DVTAutoLinkManager.getInstance().saveUserAutolinked(project, filePath);
                }
                catch (CoreException e) {
                    DVTExceptionHandler.handle(e, "Internal Error", "Create DVT Auto-Linked resource for file error.");
                }
            }
            final IFile finalFile = file;
            activeShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)finalFile, (boolean)true);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
        }
        return null;
    }

    protected IResource[] getSelectedResources(IStructuredSelection sel) {
        ArrayList<Object> resources = new ArrayList<Object>(sel.size());
        for (Object next : sel) {
            if (next instanceof IResource) {
                resources.add(next);
                continue;
            }
            if (next instanceof IAdaptable) {
                Object resource = ((IAdaptable)next).getAdapter(IResource.class);
                if (resource == null) continue;
                resources.add(resource);
                continue;
            }
            IAdapterManager adapterManager = Platform.getAdapterManager();
            ResourceMapping mapping = (ResourceMapping)adapterManager.getAdapter(next, ResourceMapping.class);
            if (mapping == null) continue;
            ResourceTraversal[] traversals = null;
            try {
                traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                DVTExceptionHandler.handle(e, "Internal Error", "Open DVT Auto-Linked virtual subfolder error.");
            }
            if (traversals == null) continue;
            int i = 0;
            while (i < traversals.length) {
                IResource[] traversalResources = traversals[i].getResources();
                if (traversalResources != null) {
                    int j = 0;
                    while (j < traversalResources.length) {
                        resources.add(traversalResources[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }
}

