/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.dvtcommand.OpenPredefinedProjectUtils;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectValidationMessage;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectsWizard;

public class OpenProjectCommand
extends AbstractHandler {
    private static final String USER_HOME = "user.home";
    public static final String PROJECT_NAME_PARAMETER_KEY = "projectName";
    public static final String OPEN_FILE_PARAMETER_KEY = "openFile";
    public static final String OVERWRITE = "overwrite";
    public static final String TARGET_DIR_PARAMETER_KEY = "targetDir";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String destinationFolder = "";
        Map parameters = event.getParameters();
        if (!parameters.containsKey(PROJECT_NAME_PARAMETER_KEY)) {
            return null;
        }
        String projectName = (String)parameters.get(PROJECT_NAME_PARAMETER_KEY);
        if (parameters.containsKey(TARGET_DIR_PARAMETER_KEY)) {
            destinationFolder = (String)parameters.get(TARGET_DIR_PARAMETER_KEY);
        } else {
            destinationFolder = System.getenv("DVT_PREDEFINED_PROJECTS_TARGET");
            if (destinationFolder == null || destinationFolder.isEmpty()) {
                destinationFolder = Path.fromOSString((String)System.getProperty(USER_HOME)).append("dvt_predefined_projects_target").toOSString();
            }
        }
        boolean isOverwrite = Boolean.parseBoolean((String)parameters.get(OVERWRITE));
        String openFile = (String)parameters.get(OPEN_FILE_PARAMETER_KEY);
        PredefinedProjectValidationMessage validationMessage = OpenPredefinedProjectUtils.validateProjectFields(projectName, destinationFolder, isOverwrite);
        if (validationMessage != PredefinedProjectValidationMessage.NO_PROBLEM) {
            IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            PredefinedProjectsWizard fWizard = new PredefinedProjectsWizard(projectName, openFile);
            fWizard.init(window.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)fWizard);
            dialog.open();
            return null;
        }
        String selectedProjectPath = OpenPredefinedProjectUtils.getSelectedProjectPath(projectName);
        if (selectedProjectPath == null) {
            return null;
        }
        String destinationPath = Path.fromOSString((String)destinationFolder).append(projectName).toOSString();
        OpenPredefinedProjectUtils.performFinishWithNoWizard(destinationPath, selectedProjectPath, isOverwrite, openFile, null);
        return null;
    }
}

