/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import ro.amiq.dvt.ui.actions.TerminalHandler;
import ro.amiq.dvt.utils.DVTFileUtils;

public class OpenTerminalHereHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!TerminalHandler.hasHandler()) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            if (!(activePart instanceof IEditorPart)) {
                return null;
            }
            IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
            if (!(input instanceof IFileEditorInput)) {
                return null;
            }
            IFile file = ((IFileEditorInput)input).getFile();
            if (file == null) {
                return null;
            }
            selection = new StructuredSelection((Object)file);
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Object obj : structuredSelection.toList()) {
            IResource resource;
            if (obj instanceof IResource) {
                resources.add((IResource)obj);
                continue;
            }
            if (!(obj instanceof IAdaptable) || (resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) == null) continue;
            resources.add(resource);
        }
        Map<IResource, IPath> resolvedPaths = DVTFileUtils.getInstance().resolveResourcesPaths(resources);
        StringBuilder unresolvedPaths = new StringBuilder();
        for (Map.Entry<IResource, IPath> entry : resolvedPaths.entrySet()) {
            IResource resource = entry.getKey();
            IPath resolvedPath = entry.getValue();
            if (resolvedPath != null) {
                if (resource instanceof IFile) {
                    resolvedPath = resolvedPath.removeLastSegments(1);
                }
                TerminalHandler.openTerminal(resolvedPath);
                continue;
            }
            unresolvedPaths.append(resource.getFullPath()).append('\n');
        }
        if (unresolvedPaths.length() > 0) {
            new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Open Terminal Here", null, "The following virtual resources were excluded because the physical path can't be resolved:\n" + unresolvedPaths.toString(), 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
        }
        return null;
    }
}

