/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.builders.DVTBuildReportModel;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class ParserProfileDialog
extends TitleAreaDialog {
    private static final int DEFAULT_MIN_PARSING_TIME = 100;
    private static final int MIN_COLLECTION_INTERVAL = 100;
    private static final int MIN_PARSING_TIME = 100;
    private static final String INTERVAL_LOWER_THAT_MINIMUM_ERROR = String.format("Thread dump collection interval cannot be lower than %dms", 100);
    private static final String PARSE_TIME_LOWER_THAN_MINIMUM_ERROR = String.format("Minimum parse time cannot be lower than %dms", 100);
    private static final String SELECT_TOP_OR_SPECIFY_ADDITIONAL_FILES_ERROR = "Select at least one build report top or specify additional files";
    private CheckboxTableViewer checkboxTableViewer;
    private String[] tops;
    private Object[] selectedTops;
    private int collectionInterval = 500;
    private int minimumParsingDuration = 100;
    private int maxNumberOfDumps;
    private String[] additionalFiles;
    private Text additionalFilesInput;
    private Text intervalInput;
    private Text minimumParsingDurationInput;
    private Text maxDumpsInput;
    private DVTBuildReportModel reportModel;
    private List<String> formErrors = new ArrayList<String>();

    public ParserProfileDialog(Shell parent, String[] tops, IProject project) {
        super(parent);
        this.tops = tops;
        this.reportModel = DVTBuildConsoleRegistry.getConsole(project).getReportModel();
    }

    public void create() {
        super.create();
        this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_TITLE));
        this.setTitle("Fill in the build with parser profile parameters.");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_IMAGE));
        newShell.setText("Configure Build with Parser Profile");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout mainLayout = new GridLayout(1, false);
        container.setLayout((Layout)mainLayout);
        Label topsLabel = new Label(container, 64);
        topsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        topsLabel.setText("Build report tops:");
        this.createCheckboxSelectionTable(container);
        Label additionalFilesLabel = new Label(container, 64);
        additionalFilesLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        additionalFilesLabel.setText("Additional file path matchers:");
        this.createAdditionalFilesInput(container);
        this.createNumericalInputs(container);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.addError(SELECT_TOP_OR_SPECIFY_ADDITIONAL_FILES_ERROR);
    }

    private void createCheckboxSelectionTable(Composite parent) {
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2560);
        this.checkboxTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, false));
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        if (this.reportModel.getTopFilesByCompileTime().isEmpty() || this.reportModel.getTopFilesByNofLines().isEmpty()) {
            this.checkboxTableViewer.getTable().setEnabled(false);
        }
        this.checkboxTableViewer.setInput((Object)this.tops);
        this.checkboxTableViewer.addCheckStateListener(e -> {
            if (this.checkboxTableViewer.getCheckedElements().length > 0) {
                this.removeError(SELECT_TOP_OR_SPECIFY_ADDITIONAL_FILES_ERROR);
            } else if (this.additionalFilesInput.getText().isEmpty()) {
                this.addError(SELECT_TOP_OR_SPECIFY_ADDITIONAL_FILES_ERROR);
            }
        });
    }

    private void createAdditionalFilesInput(Composite container) {
        this.additionalFilesInput = new Text(container, 2626);
        this.additionalFilesInput.setText("");
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 5 * this.additionalFilesInput.getLineHeight();
        this.additionalFilesInput.setLayoutData((Object)gridData);
        this.additionalFilesInput.addModifyListener(e -> {
            Text input = (Text)e.getSource();
            String string = input.getText();
            try {
                if (!string.isEmpty()) {
                    this.additionalFiles = string.split("\n");
                    this.removeError(SELECT_TOP_OR_SPECIFY_ADDITIONAL_FILES_ERROR);
                } else if (this.checkboxTableViewer.getCheckedElements().length == 0) {
                    this.addError(SELECT_TOP_OR_SPECIFY_ADDITIONAL_FILES_ERROR);
                }
            }
            catch (NumberFormatException ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        });
    }

    private void createNumericalInputs(Composite parent) {
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label intervalLabel = new Label(composite, 0);
        intervalLabel.setText("Collection interval (ms)");
        this.createCollectionIntervalInput(composite);
        Label minimumParsingDurationLabel = new Label(composite, 0);
        minimumParsingDurationLabel.setText("Minimum parse time (ms)");
        this.createMinimumParsingDurationInput(composite);
        Label maxDumpsLabel = new Label(composite, 0);
        maxDumpsLabel.setText("Max number of dumps (0 = unlimited)");
        this.createMaxDumpsInput(composite);
    }

    private void createCollectionIntervalInput(Composite composite) {
        this.intervalInput = new Text(composite, 2048);
        this.intervalInput.setText(String.valueOf(this.collectionInterval));
        this.intervalInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.intervalInput.addVerifyListener(e -> this.validateIsDigit(e));
        this.intervalInput.addModifyListener(e -> {
            Text input = (Text)e.getSource();
            String string = input.getText();
            try {
                if (!string.isEmpty()) {
                    this.collectionInterval = Integer.valueOf(string);
                    this.removeError(INTERVAL_LOWER_THAT_MINIMUM_ERROR);
                    if (this.collectionInterval < 100) {
                        this.addError(INTERVAL_LOWER_THAT_MINIMUM_ERROR);
                    } else {
                        this.removeError(INTERVAL_LOWER_THAT_MINIMUM_ERROR);
                    }
                } else {
                    this.addError(INTERVAL_LOWER_THAT_MINIMUM_ERROR);
                }
            }
            catch (NumberFormatException ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        });
    }

    private void createMinimumParsingDurationInput(Composite composite) {
        this.minimumParsingDurationInput = new Text(composite, 2048);
        this.minimumParsingDurationInput.setText(String.valueOf(this.minimumParsingDuration));
        this.minimumParsingDurationInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minimumParsingDurationInput.addVerifyListener(e -> this.validateIsDigit(e));
        this.minimumParsingDurationInput.addModifyListener(e -> {
            Text input = (Text)e.getSource();
            String string = input.getText();
            try {
                if (!string.isEmpty()) {
                    this.minimumParsingDuration = Integer.valueOf(string);
                    this.removeError(PARSE_TIME_LOWER_THAN_MINIMUM_ERROR);
                    if (this.minimumParsingDuration < 100) {
                        this.addError(PARSE_TIME_LOWER_THAN_MINIMUM_ERROR);
                    } else {
                        this.removeError(PARSE_TIME_LOWER_THAN_MINIMUM_ERROR);
                    }
                } else {
                    this.addError(PARSE_TIME_LOWER_THAN_MINIMUM_ERROR);
                }
            }
            catch (NumberFormatException ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        });
    }

    private void createMaxDumpsInput(Composite composite) {
        this.maxDumpsInput = new Text(composite, 2048);
        this.maxDumpsInput.setText(String.valueOf(this.maxNumberOfDumps));
        this.maxDumpsInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maxDumpsInput.addVerifyListener(e -> this.validateIsDigit(e));
        this.maxDumpsInput.addModifyListener(e -> {
            Text input = (Text)e.getSource();
            String string = input.getText();
            try {
                this.maxNumberOfDumps = !string.isEmpty() ? Integer.valueOf(string) : 0;
            }
            catch (NumberFormatException ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        });
    }

    protected void okPressed() {
        IProject project = RfGUIReferencesUtils.getSelectedProject();
        if (project == null) {
            return;
        }
        this.selectedTops = this.checkboxTableViewer.getCheckedElements();
        if (this.maxNumberOfDumps == 0) {
            this.maxNumberOfDumps = Integer.MAX_VALUE;
        }
        super.okPressed();
    }

    public Object[] getSelectedTops() {
        return this.selectedTops;
    }

    public int getCollectionInterval() {
        return this.collectionInterval;
    }

    public int getMinimumParsingDuration() {
        return this.minimumParsingDuration;
    }

    public int getMaxNumberOfDumps() {
        return this.maxNumberOfDumps;
    }

    public String[] getAdditionalFiles() {
        return this.additionalFiles;
    }

    private void addError(String message) {
        this.setErrorMessage(message);
        if (this.formErrors.indexOf(message) == -1) {
            this.formErrors.add(message);
        }
        this.getButton(0).setEnabled(false);
    }

    private void removeError(String message) {
        int errorIndex = this.formErrors.indexOf(message);
        if (errorIndex != -1) {
            this.formErrors.remove(errorIndex);
        }
        if (this.formErrors.isEmpty()) {
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        } else {
            this.setErrorMessage(this.formErrors.get(0));
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    private void validateIsDigit(VerifyEvent e) {
        String string = e.text;
        if (string.length() > 0 && !Character.isDigit(string.charAt(string.length() - 1))) {
            e.doit = false;
        }
    }
}

