/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.builders.DVTBuildReportModel;
import ro.amiq.dvt.builders.ParserProfileManager;
import ro.amiq.dvt.builders.TopStatsFileInfo;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.ui.actions.ParserProfileDialog;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class ParserProfileHandler
extends AbstractHandler {
    private static final String TIME = "Parse time";
    private static final String LINES = "Number of lines";
    private static final String PARSE_SPEED = "Parse speed";
    private static final String[] TOP_NAMES = new String[]{"Parse time", "Number of lines", "Parse speed"};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IProject project = RfGUIReferencesUtils.getSelectedProject();
        if (project == null) {
            Status status = new Status(1, "ro.amiq.dvt", "No project selected");
            ErrorDialog errorDialog = new ErrorDialog(shell, "Error", "Select a DVT Project.", (IStatus)status, 1);
            errorDialog.open();
            return null;
        }
        ParserProfileDialog dialog = new ParserProfileDialog(shell, TOP_NAMES, project);
        if (dialog.open() != 0) {
            return null;
        }
        List<Object> selectedTops = Arrays.asList(dialog.getSelectedTops());
        int threadDumpCollectionInterval = dialog.getCollectionInterval();
        int minimumParsingDuration = dialog.getMinimumParsingDuration();
        int maxNumberOfThreadDumps = dialog.getMaxNumberOfDumps();
        String[] threadDumpAdditionalFilesMatchers = dialog.getAdditionalFiles();
        DVTBuildReportModel reportModel = DVTBuildConsoleRegistry.getConsole(project).getReportModel();
        ParserProfileManager parserProfileModel = ParserProfileManager.getInstance();
        HashSet<String> threadDumpCollectionFiles = new HashSet<String>();
        if (selectedTops.contains(TIME)) {
            threadDumpCollectionFiles.addAll(reportModel.getTopFilesByCompileTime().values().stream().flatMap(list -> list.stream()).filter(f2 -> f2.getTime() >= (long)minimumParsingDuration).map(TopStatsFileInfo::getParserPath).map(t -> t.toString()).collect(Collectors.toList()));
        }
        if (selectedTops.contains(LINES)) {
            threadDumpCollectionFiles.addAll(reportModel.getTopFilesByNofLines().values().stream().flatMap(Collection::stream).filter(f2 -> f2.getTime() >= (long)minimumParsingDuration).map(TopStatsFileInfo::getParserPath).map(t -> t.toString()).collect(Collectors.toList()));
        }
        if (selectedTops.contains(PARSE_SPEED)) {
            threadDumpCollectionFiles.addAll(reportModel.getTopFilesByCompilationSpeed().values().stream().flatMap(Collection::stream).filter(f2 -> f2.getTime() >= (long)minimumParsingDuration).map(TopStatsFileInfo::getParserPath).map(t -> t.toString()).collect(Collectors.toList()));
        }
        parserProfileModel.setParserProfile(threadDumpCollectionFiles, threadDumpCollectionInterval, maxNumberOfThreadDumps, threadDumpAdditionalFilesMatchers);
        DVTBuildUtils.buildWithProgressDialog(project);
        return null;
    }
}

