/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class ProjectRebuildHandler
extends AbstractHandler {
    public static final String INTERNAL = "internal";
    public static final String EXTERNAL = "external";
    public static final String TESTS_ONLY = "tests_only";
    public static final String PARAM_BUILD_KIND = "ro.amiq.dvt.ui.rebuild.kind";
    public static final String PARAM_CLEAN_ONLY = "ro.amiq.dvt.ui.rebuild.cleanOnly";

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public static void build(ExecutionEvent event) {
        final IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null || !project.isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(project)) {
            return;
        }
        BuildKind tmpBuildKind = BuildKind.ALL;
        if (INTERNAL.equals(event.getParameter(PARAM_BUILD_KIND))) {
            tmpBuildKind = BuildKind.INTERNAL;
        } else if (EXTERNAL.equals(event.getParameter(PARAM_BUILD_KIND))) {
            tmpBuildKind = BuildKind.EXTERNAL;
        } else if (TESTS_ONLY.equals(event.getParameter(PARAM_BUILD_KIND))) {
            tmpBuildKind = BuildKind.TESTS_ONLY;
        }
        final BuildKind buildKind = tmpBuildKind;
        if (new Boolean(event.getParameter(PARAM_CLEAN_ONLY)).booleanValue()) {
            switch (buildKind) {
                case TESTS_ONLY: {
                    DVTBuildUtils.testsInternalBuilder(project);
                    break;
                }
                case INTERNAL: {
                    DVTBuildUtils.cleanInternalBuilder(project);
                    break;
                }
                case EXTERNAL: {
                    DVTBuildUtils.cleanExternalBuilders(project);
                    break;
                }
                default: {
                    DVTBuildUtils.cleanAllBuilders(project);
                    break;
                }
            }
        } else {
            try {
                IWorkbenchWindow w = Utils.getActiveWorkbenchWindow();
                if (w == null) {
                    return;
                }
                ISaveableFilter filter = (saveable, containingParts) -> {
                    IWorkbenchPart[] iWorkbenchPartArray = containingParts;
                    int n = containingParts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file;
                        IEditorInput editorInput;
                        IWorkbenchPart containingPart = iWorkbenchPartArray[n2];
                        if (containingPart instanceof IEditorPart && ((editorInput = ((IEditorPart)containingPart).getEditorInput()) instanceof FileEditorInput ? (file = ((FileEditorInput)editorInput).getFile()) != null && file.getProject() == project : editorInput instanceof FileStoreEditorInput && containingPart instanceof DVTEditor)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                };
                boolean autoSave = DVTPlugin.getDefault().getPreferenceStore().getBoolean("autoSaveBeforeRebuild");
                boolean saveAll = PlatformUI.getWorkbench().saveAll((IShellProvider)w, (IRunnableContext)w, filter, !autoSave);
                if (!saveAll) {
                    return;
                }
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    switch (buildKind) {
                        case TESTS_ONLY: {
                            DVTBuildUtils.testsInternalBuilder(project);
                            break;
                        }
                        case INTERNAL: {
                            DVTBuildUtils.runInternalBuilder(project);
                            break;
                        }
                        case EXTERNAL: {
                            DVTBuildUtils.externalBuildWithProgress(project);
                            break;
                        }
                        default: {
                            DVTBuildUtils.fullBuildWithProgress(project);
                        }
                    }
                }
            });
        }
    }

    public static void rebuildExternalWithArgs(final IProject project, final Map<String, String> args) {
        final IResource[] dirtyResources = ro.amiq.dvt.utils.Utils.getDirtyResources(project);
        if (dirtyResources != null && dirtyResources.length > 0) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean autoSave = DVTPlugin.getDefault().getPreferenceStore().getBoolean("autoSaveBeforeRebuild");
                        IDE.saveAllEditors((IResource[])dirtyResources, (!autoSave ? 1 : 0) != 0);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DVTBuildUtils.externalBuildWithProgress(project, args);
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ProjectRebuildHandler.build(event);
        return null;
    }

    private static enum BuildKind {
        ALL,
        INTERNAL,
        EXTERNAL,
        TESTS_ONLY;

    }
}

