/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.Utils;

public class ProjectSelectionDialog {
    public static IProject selectProject() {
        return ProjectSelectionDialog.selectProject("Select DVT Project", "Select a DVT Project from Workspace", null, true, null);
    }

    public static IProject selectProjectWithFilterNature(String filterNature) {
        return ProjectSelectionDialog.selectProject("Select DVT Project", "Select a DVT Project from Workspace", null, true, filterNature);
    }

    public static List<IProject> getDVTProjectsFromWorkspace(String filterNature) {
        ArrayList<IProject> dvtProjects = new ArrayList<IProject>();
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        try {
            IProject[] iProjectArray = allProjects;
            int n = allProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if ((filterNature == null || !project.hasNature(filterNature)) && Utils.isAccessibleDVTProject(project)) {
                    dvtProjects.add(project);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return dvtProjects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IProject selectProject(String title, String message, IProject initialSelection, boolean selectAndReveal, String filterNature) {
        try {
            List<IProject> dvtProjects = ProjectSelectionDialog.getDVTProjectsFromWorkspace(filterNature);
            IProject selectedProject = null;
            if (dvtProjects.size() > 1) {
                Shell shell = null;
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return null;
                }
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null) {
                    shell = activeWorkbenchWindow.getShell();
                } else {
                    Display display = workbench.getDisplay();
                    if (display == null) {
                        display = Display.getDefault();
                    }
                    if ((shell = display.getActiveShell()) == null) {
                        shell = new Shell(display);
                    }
                }
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider());
                dialog.setElements((Object[])dvtProjects.toArray(new IProject[dvtProjects.size()]));
                dialog.setMultipleSelection(false);
                dialog.setTitle(title);
                dialog.setMessage(message);
                if (initialSelection != null) {
                    dialog.setInitialElementSelections(Arrays.asList(initialSelection));
                }
                dialog.open();
                Object[] result = dialog.getResult();
                if (result == null || result.length == 0) {
                    return null;
                }
                if (result[0] == null || !(result[0] instanceof IProject)) {
                    return null;
                }
                selectedProject = (IProject)result[0];
            } else {
                if (dvtProjects.size() != 1) {
                    return null;
                }
                selectedProject = dvtProjects.get(0);
            }
            DVTPlugin.getSelectionManager().setLastSelectedResource((IResource)selectedProject);
            if (selectAndReveal) {
                final IProject fSelProj = selectedProject;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DVTPlugin.getSelectionManager().selectAndReveal((IResource)fSelProj, DVTUiUtils.getActiveWorkbenchWindow());
                    }
                });
            }
            return selectedProject;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

