/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class RebuildAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private IResource fResource;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            if (selection instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IAdaptable) {
                    this.fResource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                    action.setEnabled(true);
                } else if (obj instanceof IResource) {
                    this.fResource = (IResource)obj;
                    action.setEnabled(true);
                } else {
                    this.fResource = null;
                    action.setEnabled(false);
                }
            } else {
                this.fResource = null;
                action.setEnabled(false);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void run(IAction action) {
        Assert.isNotNull((Object)this.fResource);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IProject project = RebuildAction.this.fResource.getProject();
                if (project != null) {
                    DVTBuildUtils.fullBuildWithProgress(project);
                }
            }
        });
    }

    public void dispose() {
        this.fResource = null;
    }

    public void init(IWorkbenchWindow window) {
    }
}

