/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.actions.RenameUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameProcessor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactoring;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameWizard;
import ro.amiq.dvt.ui.search.PortSignalEnum;

public abstract class RenameRefactorAction
extends TextEditorAction {
    private static final String MD5_STRING = "MD5";
    private static final String DIALOG_MESSAGE = "The following files need to be incrementally compiled before the refactoring operation.\nDo you want to proceed?";
    protected static final String RENAME_REFACTORING_PREFERENCES_PAGE = "Rename Refactoring Preferences Page";
    public static final String RENAME_ACROSS_THE_DESIGN_HIERARCHY_ACTION_LABEL = "Rename Port Across the Design Hierarchy";
    protected static final String DIALOG_ERROR_MESSAGE = "The operation is not allowed on the current selection. Please select a port or a signal.";
    protected static final String DIALOG_WARNING_MESSAGE = "The selected {0} is not connected outside this module.\nDo you want to proceed with a local rename?";
    public static final String RENAME_REFACTORING_ACROSS_DESIGN_HIERARCHY_PREFERENCES_PAGE = "Rename Refactoring Across Design Hierarchy Preferences Page";
    protected static final String SIGNAL_NOT_CONNECTED = "Signal not connected";
    protected static final String PORT_ALREADY_CONNECTED = "The selected port is already connected.";
    protected static final String MESSAGE_INPUT_OUTPUT_PORT = "Cannot connect an input port as output.";
    protected static final String MESSAGE_OUTPUT_INPUT_PORT = "Cannot connect an output port as input.";
    protected static final String THE_SELECTED_ELEMENT_IS_NOT_ELABORATED = "The selected element is not elaborated.";
    protected static final String IS_PRECOMPILED_ELEMENT_RENAME_MESSAGE = "The selected element cannot be refactored because it is precompiled.";
    protected DVTEditor dvtEditor;

    public RenameRefactorAction(ResourceBundle bundle, String prefix, DVTEditor editor) {
        super(bundle, prefix, (ITextEditor)editor);
        this.dvtEditor = editor;
    }

    protected void popUnelaboratedElementAtCursor() {
        if (TestHelper.isTestMode()) {
            return;
        }
        RfGUIReferencesUtils.popUpUnsupportedOperation(THE_SELECTED_ELEMENT_IS_NOT_ELABORATED);
    }

    protected void popPortAlreadyConnected() {
        if (TestHelper.isTestMode()) {
            return;
        }
        RfGUIReferencesUtils.popUpUnsupportedOperation(PORT_ALREADY_CONNECTED);
    }

    public void run() {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        Map<IFile, IDocument> outOfSyncFilesMap = RenameRefactorAction.computeOutOfSyncFilesMap(project);
        if (!RenameRefactorAction.ensureFilesInSync(outOfSyncFilesMap)) {
            return;
        }
        DVTRenameRefactorInfo refactorInfo = this.getRefactoringInfo();
        String unsupportedElementMessage = this.getUnsupportedElementMessage();
        if (refactorInfo == null) {
            RenameUtils.INSTANCE.popUnsupportedElement(unsupportedElementMessage);
            return;
        }
        boolean isRenameRefactorValidContext = RenameUtils.INSTANCE.isRenameRefactorValidContext(refactorInfo.getElement(), project, true, unsupportedElementMessage, this.getPredefinedElementMessage());
        if (!isRenameRefactorValidContext) {
            return;
        }
        boolean shouldContinue = this.isValidElementForRefactoringOperation(refactorInfo);
        if (!shouldContinue) {
            return;
        }
        if (TestHelper.isTestMode()) {
            this.testApplyChanges(refactorInfo);
        } else {
            this.openRenameWizard(refactorInfo);
        }
        Map<IFile, IDocument> outOfSyncAffectedFilesMap = this.computeOutOfSyncAffectedDirtyDocuments(project, refactorInfo);
        RenameRefactorAction.scheduleReparseForModifiedFiles(outOfSyncAffectedFilesMap, null, false);
    }

    protected void openRenameWizard(DVTRenameRefactorInfo refactorInfo) {
        DVTRenameDelegate delegate = this.getRefactorDelegate(refactorInfo);
        DVTRenameProcessor processor = this.getRefactorProcessor(delegate);
        DVTRenameRefactoring refactoring = new DVTRenameRefactoring(processor);
        DVTRenamePreferencesPage preferencesPage = this.getPage(refactorInfo);
        this.setInfoForRenameOperation(refactorInfo, this.dvtEditor);
        DVTRenameWizard wizard = this.getRefactorWizard(refactoring, preferencesPage);
        boolean anotherRefactoringSession = this.alreadyAnExistingRefactoringSessionInProgress(wizard);
        if (anotherRefactoringSession) {
            return;
        }
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(this.getShell(), "");
        }
        catch (InterruptedException interruptedException) {}
    }

    public static boolean ensureFilesInSync(final Map<IFile, IDocument> unsavedFilesMap) {
        if (unsavedFilesMap == null || unsavedFilesMap.isEmpty()) {
            return true;
        }
        int[] messageDialogExitCode = RenameRefactorAction.getMessageDialogUserOption(unsavedFilesMap);
        if (messageDialogExitCode[0] != 0) {
            return false;
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        RenameRefactorAction.scheduleReparseForModifiedFiles(unsavedFilesMap, monitor, true);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return !progressDialog.getProgressMonitor().isCanceled();
    }

    public static void scheduleReparseForModifiedFiles(Map<IFile, IDocument> unsavedFilesMap, IProgressMonitor monitor, boolean blockingReparse) {
        if (unsavedFilesMap == null || unsavedFilesMap.isEmpty()) {
            return;
        }
        for (Map.Entry<IFile, IDocument> entry : unsavedFilesMap.entrySet()) {
            IDocument document;
            IFile file = entry.getKey();
            IDVTFile modelFile = RfSearchUtils.getIDVTFile(file, file.getProject());
            if (modelFile == null || (document = entry.getValue()) == null) continue;
            if (blockingReparse) {
                modelFile.blockingReparse(monitor, document);
                continue;
            }
            modelFile.scheduleReparse(false, true, 0L, document, false, true);
        }
    }

    public static int[] getMessageDialogUserOption(Map<IFile, IDocument> unsavedFilesMap) {
        final int[] messageDialogExitCode = new int[]{0};
        if (TestHelper.isTestMode()) {
            return messageDialogExitCode;
        }
        List<String> filesFullPathList = unsavedFilesMap.keySet().stream().map(iFile -> iFile.getLocation().toOSString()).collect(Collectors.toList());
        Collections.sort(filesFullPathList);
        final String[] filesFullPathArray = filesFullPathList.toArray(new String[filesFullPathList.size()]);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Database out of sync", null, RenameRefactorAction.DIALOG_MESSAGE, 2, new String[]{"Yes", "No"}, 0){

                    protected Control createCustomArea(Composite parent) {
                        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2560);
                        list.setItems(filesFullPathArray);
                        GridData gridData = new GridData(4, 4, true, true);
                        gridData.heightHint = 150;
                        list.setLayoutData((Object)gridData);
                        return list;
                    }
                };
                messageDialogExitCode[0] = dialog.open();
            }
        });
        return messageDialogExitCode;
    }

    public DVTRenameRefactorInfo getRefactoringInfo() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return null;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return null;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return null;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        return this.getRefactorinfo(textEditor, document, offset);
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void testApplyChanges(DVTRenameRefactorInfo refactorInfo) {
        DVTRenameDelegate delegate = this.getRefactorDelegate(refactorInfo);
        DVTRenameProcessor processor = new DVTRenameProcessor(delegate);
        DVTRenameRefactoring refactoring = new DVTRenameRefactoring(processor);
        DVTRenamePreferencesPage page = this.getPage(refactorInfo);
        this.testSetInfoForRenameOperation(refactorInfo, this.dvtEditor);
        DVTRenameWizard wizard = new DVTRenameWizard((Refactoring)refactoring, page);
        final RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    op.run(RenameRefactorAction.this.getShell(), "");
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
        TestHelper.runRefactoringThread(wizard, r, "OK", TestHelper.getInstance().getRefactoringText());
    }

    public boolean popUnconnectedPortSignalWarning(PortSignalEnum portOrSignalEnum) {
        return false;
    }

    public boolean hasPortConnections(DVTRenameRefactorInfo refactorInfo) {
        return true;
    }

    public PortSignalEnum getPortSignalEnum(DVTRenameRefactorInfo refactorInfo) {
        return PortSignalEnum.SIGNAL_MATCH;
    }

    public void popNoPortOrSignalElement() {
    }

    public DVTRenamePreferencesPage getPage(DVTRenameRefactorInfo refactorInfo) {
        return new DVTRenamePreferencesPage(RENAME_REFACTORING_PREFERENCES_PAGE, refactorInfo, this.dvtEditor);
    }

    protected abstract DVTRenameRefactorInfo getRefactorinfo(ITextEditor var1, IDocument var2, int var3);

    protected abstract DVTRenameDelegate getRefactorDelegate(DVTRenameRefactorInfo var1);

    protected DVTRenameProcessor getRefactorProcessor(DVTRenameDelegate delegate) {
        return new DVTRenameProcessor(delegate);
    }

    protected DVTRenameWizard getRefactorWizard(DVTRenameRefactoring refactoring, DVTRenamePreferencesPage preferencesPage) {
        return new DVTRenameWizard((Refactoring)refactoring, preferencesPage);
    }

    protected abstract String getUnsupportedElementMessage();

    protected abstract String getPredefinedElementMessage();

    public static Map<IFile, IDocument> computeOutOfSyncFilesMap(IProject currentProject) {
        if (currentProject == null) {
            return null;
        }
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        IWorkbench workbench = DVTPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows == null || windows.length == 0) {
            return result;
        }
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof DVTEditor && ep.isDirty()) {
                        IFile file;
                        IProject project;
                        IDocument document = ((DVTEditor)ep).getDocument();
                        IResource resource = (IResource)((DVTEditor)ep).getEditorInput().getAdapter(IResource.class);
                        if (resource instanceof IFile && currentProject.equals((Object)(project = (file = (IFile)resource).getProject()))) {
                            RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
                            try {
                                String[] natures;
                                String[] stringArray = natures = project.getDescription().getNatureIds();
                                int n = natures.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IRfFileDef fileDef;
                                    String nature = stringArray[n2];
                                    IRfSingleLangProject singleLangProject = rfMixedLangProject.getSingleLangProject(nature);
                                    if (singleLangProject != null && (fileDef = singleLangProject.getFile((IResource)file)) != null) {
                                        byte[] fileDefMd5 = fileDef.getParserPath().getMd5();
                                        MessageDigest md = null;
                                        try {
                                            md = MessageDigest.getInstance(MD5_STRING);
                                            String string = document.get();
                                            md.update(string.getBytes());
                                            byte[] documentMd5 = md.digest();
                                            boolean isMd5Equals = Arrays.equals(documentMd5, fileDefMd5);
                                            if (!isMd5Equals) {
                                                result.put(file, document);
                                            }
                                        }
                                        catch (NoSuchAlgorithmException e) {
                                            DVTLogger.INSTANCE.logError((Throwable)e);
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            catch (CoreException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private Map<IFile, IDocument> computeOutOfSyncAffectedDirtyDocuments(IProject currentProject, DVTRenameRefactorInfo refactorInfo) {
        if (currentProject == null) {
            return null;
        }
        if (refactorInfo == null || refactorInfo.getMatches() == null) {
            return null;
        }
        Set<IResource> affectedResources = refactorInfo.getMatches().keySet();
        if (affectedResources == null || affectedResources.isEmpty()) {
            return null;
        }
        IWorkbench workbench = DVTPlugin.getDefault().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows == null || windows.length == 0) {
            return null;
        }
        return RenameRefactorAction.computeOutOfSyncAffectedDirtyDocuments(currentProject, affectedResources, windows);
    }

    public static Map<IFile, IDocument> computeOutOfSyncAffectedDirtyDocuments(IProject currentProject, Set<? extends IResource> affectedResources, IWorkbenchWindow[] windows) {
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof DVTEditor && ep.isDirty()) {
                        IFile file;
                        IProject project;
                        IResource resource;
                        IDocument document = ((DVTEditor)ep).getDocument();
                        IEditorInput editorInput = ((DVTEditor)ep).getEditorInput();
                        if (editorInput != null && (resource = (IResource)editorInput.getAdapter(IResource.class)) instanceof IFile && currentProject.equals((Object)(project = (file = (IFile)resource).getProject())) && affectedResources.contains(file)) {
                            result.put(file, document);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private IProject getProject() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return null;
        }
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return null;
        }
        return resouce.getProject();
    }

    public boolean alreadyAnExistingRefactoringSessionInProgress(DVTRenameWizard wizard) {
        return false;
    }

    public void setInfoForRenameOperation(DVTRenameRefactorInfo refactorInfo, DVTEditor dvtEditor) {
    }

    public void testSetInfoForRenameOperation(DVTRenameRefactorInfo refactorInfo, DVTEditor dvtEditor) {
    }

    public boolean isValidElementForRefactoringOperation(DVTRenameRefactorInfo refactorInfo) {
        return true;
    }
}

