/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;

public interface RenameUtilsCommon {
    public static final String IS_PRECOMPILED_ELEMENT_RENAME_MESSAGE = "The selected element cannot be refactored because it is precompiled.";

    default public boolean isRenameRefactorValidContext(IRfNamedElement element, IProject project, boolean shouldDisplayMessage, String unsupportedElementErrorMessage, String predefinedElementErrorMessage) {
        if (RfSearchUtils.isInvalidElement(element)) {
            if (shouldDisplayMessage) {
                this.popUnsupportedElement(unsupportedElementErrorMessage);
            }
            return false;
        }
        boolean predefined = RfSearchUtils.isPredefinedElement(element, project);
        if (predefined) {
            if (shouldDisplayMessage) {
                this.popPredefinedElement(predefinedElementErrorMessage);
            }
            return false;
        }
        boolean precompiled = RfSearchUtils.isPrecompiledElement(element, project);
        if (precompiled) {
            if (shouldDisplayMessage) {
                this.popPrecompiledElement();
            }
            return false;
        }
        return true;
    }

    public void popUnsupportedElement(String var1);

    public void popPredefinedElement(String var1);

    public void popPrecompiledElement();
}

