/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.AddResourceToBuildConfigHandler;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class SetActiveTestFileHandler
extends AddResourceToBuildConfigHandler {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String ACTIVE_TEST_FILE_DIRECTIVE = "+dvt_active_test+";
    private IFile fFile;

    public boolean isEnabled() {
        block5: {
            block4: {
                try {
                    if (this.fEvaluationContext != null) break block4;
                    return false;
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            this.checkSelection();
            if (this.fFile != null) break block5;
            return false;
        }
        IProject project = this.fFile.getProject();
        return (project.hasNature("ro.amiq.edt.enature") || project.hasNature("ro.amiq.slndt.slnnature") || project.hasNature("ro.amiq.msdldt.msdlnature") || project.hasNature("ro.amiq.pssdt.pssnature")) && !(this.fFile instanceof IProject) && !(this.fFile instanceof IFolder);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            block9: {
                this.fEvaluationContext = (IEvaluationContext)event.getApplicationContext();
                this.checkSelection();
                if (this.fFile != null && this.fProject != null) break block9;
                return null;
            }
            if (this.fProject.hasNature("ro.amiq.edt.enature") || this.fProject.hasNature("ro.amiq.slndt.slnnature") || this.fProject.hasNature("ro.amiq.msdldt.msdlnature") || this.fProject.hasNature("ro.amiq.pssdt.pssnature")) break block10;
            return null;
        }
        try {
            File dotDvtDir = new File(this.fProject.getLocation().toFile(), ".dvt");
            if (!dotDvtDir.exists()) {
                dotDvtDir.mkdir();
            }
            ArrayList<BuildConfigProperty> allProperties = new ArrayList<BuildConfigProperty>();
            ArrayList<String> existingTestFiles = new ArrayList<String>();
            List<BuildConfigProperty> activeBuildConfigCompactedCachedInfo = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(this.fProject);
            if (activeBuildConfigCompactedCachedInfo != null) {
                allProperties.addAll(activeBuildConfigCompactedCachedInfo);
            }
            for (BuildConfigProperty p : allProperties) {
                if (p.getKind() == 0 || !p.hasAttribute("ATTRIBUTE_TEST_FILE")) continue;
                existingTestFiles.add(p.getValue());
            }
            String toAdd = String.valueOf(NEWLINE) + ACTIVE_TEST_FILE_DIRECTIVE + (DVTFileUtils.getInstance().isLinked((IResource)this.fFile) ? this.fFile.getLocation().toOSString() : this.fFile.getProjectRelativePath().toOSString());
            String activeBuildConfig = String.valueOf(BuildConfigManager.getActiveBuildConfigName(this.fProject)) + ".build";
            File activeBuildConfigFile = new File(this.fProject.getLocation().toFile(), ".dvt/" + activeBuildConfig);
            int status = this.applyChangesFromUserInput(activeBuildConfigFile, toAdd);
            if (status == 0) {
                this.fProject.getProject().getFolder(".dvt").getFile(activeBuildConfigFile.getName()).refreshLocal(1, null);
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Set Active Test File!", null, "You set this file as Active Test File! It is recommended to rebuild for refreshing dictionary, errors etc.", 4, new String[]{"Rebuild Now", "Later"}, 0);
                    if (dialog.open() == 0) {
                        DVTBuildUtils.runInternalBuilder(SetActiveTestFileHandler.this.fProject);
                    }
                }
            });
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public void checkSelection() {
        try {
            this.fFile = null;
            this.fProject = null;
            ISelection selection = DVTPlugin.getSelectionManager().getLastSelection();
            Object obj = null;
            obj = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : DVTPlugin.getSelectionManager().getLastSelectedResource();
            if (obj != null && obj instanceof IFile) {
                this.fFile = (IFile)obj;
                this.fProject = this.fFile.getProject();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

