/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.statistics.StatisticsPreferenceDialog;
import ro.amiq.dvt.statistics.StatisticsPreferenceModel;
import ro.amiq.dvt.statistics.StatisticsPreferenceParser;
import ro.amiq.dvt.statistics.StatisticsUtilProviderBase;
import ro.amiq.dvt.ui.Utils;

public class ShowProjectStatistics
extends AbstractHandler {
    private final String PROJECT_STATISTICS_EXTENSION_POINT_ID = "ro.amiq.dvt.projectStatistics";
    private Map<String, StatisticsUtilProviderBase> fStatisticsUtilProviders = null;
    private StatisticsPreferenceModel fSpm;

    private boolean setStatisticsPreferenceModel(IWorkbenchWindow workbenchWindow, IProject project) {
        File preferenceFile = project.getLocation().append(".dvt").append(".project_statistics").toFile();
        int returnCode = new StatisticsPreferenceDialog(workbenchWindow.getShell(), preferenceFile, null).open();
        if (returnCode != 0) {
            return false;
        }
        if (preferenceFile == null) {
            return false;
        }
        try {
            StatisticsPreferenceParser parser = StatisticsPreferenceParser.newParser(preferenceFile, true);
            if (parser == null) {
                return false;
            }
            try {
                this.fSpm = parser.load();
            }
            catch (Exception exception) {}
        }
        finally {
            if (this.fSpm == null) {
                this.fSpm = new StatisticsPreferenceModel();
            }
        }
        return true;
    }

    private Map<String, StatisticsUtilProviderBase> getExtensions() {
        if (this.fStatisticsUtilProviders != null) {
            return this.fStatisticsUtilProviders;
        }
        this.fStatisticsUtilProviders = new HashMap<String, StatisticsUtilProviderBase>();
        try {
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("ro.amiq.dvt.projectStatistics");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement i = iConfigurationElementArray[n2];
                Object o = i.createExecutableExtension("class");
                if (o instanceof StatisticsUtilProviderBase) {
                    StatisticsUtilProviderBase currentExtension = (StatisticsUtilProviderBase)o;
                    this.fStatisticsUtilProviders.put(currentExtension.getNature(), currentExtension);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.fStatisticsUtilProviders;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasNature(IProject project, Set<String> natureIDs) {
        try {
            String i;
            Iterator<String> iterator = natureIDs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!project.hasNature(i = iterator.next()));
            return true;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }

            public void run() throws Exception {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                IResource selectedResource = ShowProjectStatistics.this.getSelectedResource(workbenchWindow);
                IProject project = selectedResource == null || selectedResource.getProject() == null || !ShowProjectStatistics.this.hasNature(selectedResource.getProject(), ShowProjectStatistics.this.getExtensions().keySet()) ? ShowProjectStatistics.this.chooseProject(ShowProjectStatistics.this.getExtensions().keySet()) : selectedResource.getProject();
                if (project == null) {
                    return;
                }
                final IProject finalProject = project;
                final StringBuilder collectedStats = new StringBuilder();
                final File collectedStatsFile = project.getLocation().append("project_statistics.txt").toFile();
                if (!ShowProjectStatistics.this.setStatisticsPreferenceModel(workbenchWindow, project)) {
                    return;
                }
                collectedStats.append(StatisticsUtilProviderBase.getCommonStatistics(finalProject, ShowProjectStatistics.this.fSpm));
                progressDialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        int taskLength = (this).ShowProjectStatistics.this.fSpm.isPerformFullBuild() ? 12 : 6;
                        monitor.beginTask("", taskLength);
                        if ((this).ShowProjectStatistics.this.fSpm.isPerformFullBuild()) {
                            monitor.setTaskName("Building project...");
                            finalProject.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 6));
                        }
                        monitor.setTaskName("Collecting statistics");
                        for (StatisticsUtilProviderBase i : ShowProjectStatistics.this.getExtensions().values()) {
                            if (!finalProject.hasNature(i.getNature())) continue;
                            collectedStats.append(i.getStatistics(finalProject, (IProgressMonitor)new SubProgressMonitor(monitor, 6), (this).ShowProjectStatistics.this.fSpm));
                        }
                        monitor.done();
                    }
                });
                try {
                    collectedStatsFile.createNewFile();
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try (BufferedWriter out = new BufferedWriter(new FileWriter(collectedStatsFile));){
                        out.write(collectedStats.toString());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    finalProject.getFile(collectedStatsFile.getName()).refreshLocal(0, null);
                }
                catch (Exception exception) {
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ShowProjectStatistics.this.openEditor(collectedStatsFile);
                    }
                });
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
        return null;
    }

    private IResource getSelectedResource(IWorkbenchWindow workbenchWindow) {
        IResource result = null;
        if (workbenchWindow != null) {
            IEditorInput editorInput;
            IEditorPart editor;
            IWorkbenchPage activePage;
            ISelection selection = workbenchWindow.getActivePage().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object obj = structuredSelection.getFirstElement();
                if (obj instanceof IAdaptable) {
                    result = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                } else if (obj instanceof IResource) {
                    result = (IResource)obj;
                }
            } else if (selection instanceof ITextSelection && (activePage = workbenchWindow.getActivePage()) != null && (editor = activePage.getActiveEditor()) != null && (editorInput = editor.getEditorInput()) != null) {
                result = (IResource)editorInput.getAdapter(IResource.class);
            }
        }
        return result;
    }

    private void openEditor(File f2) {
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(f2.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            Object resource = editor.getEditorInput().getAdapter(IResource.class);
            if (resource != null) {
                ((IResource)resource).refreshLocal(1, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IProject chooseProject(Set<String> natureID) {
        try {
            HashSet<IProject> relevantProjects = new HashSet<IProject>();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject i = iProjectArray[n2];
                for (String j : natureID) {
                    if (!i.isAccessible() || !i.isNatureEnabled(j)) continue;
                    relevantProjects.add(i);
                }
                ++n2;
            }
            return Utils.selectProject(relevantProjects.toArray(new IProject[relevantProjects.size()]), "Select a project to collect statistics from.", (ILabelProvider)new WorkbenchLabelProvider(), null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

