/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.WorkbenchEncoding;
import org.osgi.framework.Bundle;
import ro.amiq.dvt.startup.core.DVTLogger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TerminalHandler {
    NONE,
    TM{
        private static final String TM_TERMINAL_VIEW_CORE_BUNDLE_ID = "org.eclipse.tm.terminal.view.core";
        private static final String TM_TERMINAL_VIEW_UI_BUNDLE_ID = "org.eclipse.tm.terminal.view.ui";
        private static final String TM_TERMINAL_CONNECTOR_LOCAL_BUNDLE_ID = "org.eclipse.tm.terminal.connector.local";
        private static final String TM_ITERMINAL_SERVICE_DONE_CN = "org.eclipse.tm.terminal.view.core.interfaces.ITerminalService$Done";
        private static final String TM_TERMINAL_SERVICE_FACTORY_CN = "org.eclipse.tm.terminal.view.core.TerminalServiceFactory";
        private static final String TM_LOCAL_DELEGATE_ID = "org.eclipse.tm.terminal.connector.local.launcher.local";
        private static final String TM_LOCAL_TERMINAL_CONNECTOR_ID = "org.eclipse.tm.terminal.connector.local.LocalConnector";
        private Object terminalServiceInstance;
        private Method openConsoleMethod;

        @Override
        protected boolean canHandle() {
            Bundle viewCoreBundle;
            block6: {
                viewCoreBundle = Platform.getBundle((String)TM_TERMINAL_VIEW_CORE_BUNDLE_ID);
                if (viewCoreBundle == null) {
                    return false;
                }
                Bundle viewUiBundle = Platform.getBundle((String)TM_TERMINAL_VIEW_UI_BUNDLE_ID);
                if (viewUiBundle == null) {
                    return false;
                }
                Bundle connectorLocalBundle = Platform.getBundle((String)TM_TERMINAL_CONNECTOR_LOCAL_BUNDLE_ID);
                if (connectorLocalBundle == null) {
                    return false;
                }
                try {
                    this.terminalServiceInstance = viewCoreBundle.loadClass(TM_TERMINAL_SERVICE_FACTORY_CN).getMethod(TerminalHandler.ANY_GET_SERVICE_MN, new Class[0]).invoke(null, new Object[0]);
                    if (this.terminalServiceInstance != null) break block6;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            this.openConsoleMethod = this.terminalServiceInstance.getClass().getMethod(TerminalHandler.ANY_OPEN_CONSOLE_MN, Map.class, viewCoreBundle.loadClass(TM_ITERMINAL_SERVICE_DONE_CN));
            return this.terminalServiceInstance != null && this.openConsoleMethod != null;
        }

        @Override
        protected void open(IPath path) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String encoding = "macosx".equals(Platform.getOS()) ? "UTF-8" : WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                properties.put(TerminalHandler.ANY_PROP_ENCODING, encoding);
            }
            if (path != null) {
                properties.put(TerminalHandler.ANY_PROP_WORKINGDIR, path.toOSString());
                properties.put(TerminalHandler.ANY_PROP_TITLE, String.valueOf(path.lastSegment()) + " (Local)");
            }
            properties.put(TerminalHandler.ANY_PROP_DELEGATE_ID, TM_LOCAL_DELEGATE_ID);
            properties.put(TerminalHandler.ANY_PROP_TERMINAL_CONNECTOR_ID, TM_LOCAL_TERMINAL_CONNECTOR_ID);
            properties.put(TerminalHandler.ANY_PROP_FORCE_NEW, true);
            try {
                this.openConsoleMethod.invoke(this.terminalServiceInstance, properties, null);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
    ,
    TCF{
        private static final String TCF_RUNTIME_SERVICES_BUNDLE_ID = "org.eclipse.tcf.te.runtime.services";
        private static final String TCF_RUNTIME_BUNDLE_BUNDLE_ID = "org.eclipse.tcf.te.runtime";
        private static final String TCF_SERVICE_MANAGER_CN = "org.eclipse.tcf.te.runtime.services.ServiceManager";
        private static final String TCF_ITERMINAL_SERVICE_CN = "org.eclipse.tcf.te.runtime.services.interfaces.ITerminalService";
        private static final String TCF_ICALLBACK_CN = "org.eclipse.tcf.te.runtime.interfaces.callback.ICallback";
        private static final String TCF_PROPERTIES_CONTAINER_CN = "org.eclipse.tcf.te.runtime.properties.PropertiesContainer";
        private static final String TCF_IPROPERTIES_CONTAINER_CN = "org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer";
        private static final String TCF_GET_INSTANCE_MN = "getInstance";
        private static final String TCF_PROP_CONNECTOR_TYPE_ID = "connector.type.id";
        private static final String TCF_LOCAL_CONNECTOR_ID = "org.eclipse.tcf.te.ui.terminals.type.local";
        private static final String TCF_LOCAL_DELEGATE_ID = "org.eclipse.tcf.te.ui.terminals.local.launcher.local";
        private static final String TCF_LOCAL_TERMINAL_CONNECTOR_ID = "org.eclipse.tcf.te.ui.terminals.local.LocalConnector";
        private Object terminalServiceInstance;
        private Method openConsoleMethod;
        private Class<?> propertiesContainerClass;
        private Method setPropertiesMethod;

        @Override
        protected boolean canHandle() {
            Bundle servicesBundle = Platform.getBundle((String)TCF_RUNTIME_SERVICES_BUNDLE_ID);
            if (servicesBundle == null) {
                return false;
            }
            Bundle runtimeBundle = Platform.getBundle((String)TCF_RUNTIME_BUNDLE_BUNDLE_ID);
            if (runtimeBundle == null) {
                return false;
            }
            try {
                Object managerInstance = servicesBundle.loadClass(TCF_SERVICE_MANAGER_CN).getMethod(TCF_GET_INSTANCE_MN, new Class[0]).invoke(null, new Object[0]);
                this.terminalServiceInstance = managerInstance.getClass().getMethod(TerminalHandler.ANY_GET_SERVICE_MN, Class.class).invoke(managerInstance, servicesBundle.loadClass(TCF_ITERMINAL_SERVICE_CN));
                this.openConsoleMethod = this.terminalServiceInstance.getClass().getMethod(TerminalHandler.ANY_OPEN_CONSOLE_MN, runtimeBundle.loadClass(TCF_IPROPERTIES_CONTAINER_CN), runtimeBundle.loadClass(TCF_ICALLBACK_CN));
                this.propertiesContainerClass = runtimeBundle.loadClass(TCF_PROPERTIES_CONTAINER_CN);
                this.setPropertiesMethod = this.propertiesContainerClass.getMethod("setProperties", Map.class);
            }
            catch (Exception exception) {
                return false;
            }
            return this.terminalServiceInstance != null && this.openConsoleMethod != null && this.propertiesContainerClass != null && this.setPropertiesMethod != null;
        }

        @Override
        protected void open(IPath path) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String encoding = "macosx".equals(Platform.getOS()) ? "UTF-8" : WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                properties.put(TerminalHandler.ANY_PROP_ENCODING, encoding);
            }
            if (path != null) {
                properties.put(TerminalHandler.ANY_PROP_WORKINGDIR, path.toOSString());
                properties.put(TerminalHandler.ANY_PROP_TITLE, String.valueOf(path.lastSegment()) + " (Local)");
            }
            properties.put(TerminalHandler.ANY_PROP_DELEGATE_ID, TCF_LOCAL_DELEGATE_ID);
            properties.put(TerminalHandler.ANY_PROP_TERMINAL_CONNECTOR_ID, TCF_LOCAL_TERMINAL_CONNECTOR_ID);
            properties.put(TerminalHandler.ANY_PROP_FORCE_NEW, true);
            properties.put(TCF_PROP_CONNECTOR_TYPE_ID, TCF_LOCAL_CONNECTOR_ID);
            try {
                Object propertiesContainerInstance = this.propertiesContainerClass.newInstance();
                this.setPropertiesMethod.invoke(propertiesContainerInstance, properties);
                this.openConsoleMethod.invoke(this.terminalServiceInstance, propertiesContainerInstance, null);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    };

    private static final String ANY_GET_SERVICE_MN = "getService";
    private static final String ANY_OPEN_CONSOLE_MN = "openConsole";
    private static final String ANY_PROP_TERMINAL_CONNECTOR_ID = "tm.terminal.connector.id";
    private static final String ANY_PROP_DELEGATE_ID = "delegateId";
    private static final String ANY_PROP_WORKINGDIR = "process.working_dir";
    private static final String ANY_PROP_ENCODING = "encoding";
    private static final String ANY_PROP_FORCE_NEW = "terminal.forceNew";
    private static final String ANY_PROP_TITLE = "title";
    private static TerminalHandler activeHandler;

    protected boolean canHandle() {
        return false;
    }

    protected void open(IPath path) {
    }

    public static boolean hasHandler() {
        if (activeHandler != null) {
            return activeHandler != NONE;
        }
        activeHandler = TM.canHandle() ? TM : (TCF.canHandle() ? TCF : NONE);
        return activeHandler != NONE;
    }

    public static void openTerminal(IPath path) {
        activeHandler.open(path);
    }
}

