/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.addtobuildconfig;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class AddToBuildConfigDynamicMenuHandler
extends AbstractHandler {
    private static final String NEWLINE = System.getProperty("line.separator");
    private List<IFile> fFiles = new ArrayList<IFile>();
    private IProject fProject;
    private String fErrorMessage;
    private IEvaluationContext fEvaluationContext;
    List<String> fCmdFileList = new ArrayList<String>();

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (evaluationContext instanceof IEvaluationContext) {
            this.fEvaluationContext = (IEvaluationContext)evaluationContext;
        }
    }

    public boolean isEnabled() {
        if (this.fEvaluationContext == null) {
            return false;
        }
        this.checkSelection();
        if (this.fFiles.isEmpty() || this.fProject == null) {
            return false;
        }
        this.getCmdFileExtensions();
        for (IFile iFile : this.fFiles) {
            if (!(iFile instanceof IFolder) && !(iFile instanceof IProject)) continue;
            return false;
        }
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int status;
        ArrayList<String> addedTestFiles;
        ArrayList<String> duplicates;
        ArrayList<String> added;
        block20: {
            this.fEvaluationContext = (IEvaluationContext)event.getApplicationContext();
            this.checkSelection();
            if (this.fErrorMessage != null) {
                this.popError();
                return null;
            }
            added = new ArrayList<String>();
            duplicates = new ArrayList<String>();
            addedTestFiles = new ArrayList<String>();
            if (this.fFiles == null || this.fFiles.isEmpty() || this.fProject == null) {
                return null;
            }
            status = 0;
            if (this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature") || this.fProject.hasNature("ro.amiq.edt.enature") || this.fProject.hasNature("ro.amiq.slndt.slnnature") || this.fProject.hasNature("ro.amiq.msdldt.msdlnature") || this.fProject.hasNature("ro.amiq.pssdt.pssnature") || this.fProject.hasNature("ro.amiq.vlogdt.VlogNature")) break block20;
            return null;
        }
        try {
            File dotDvtDir = new File(this.fProject.getLocation().toFile(), ".dvt");
            if (!dotDvtDir.exists()) {
                dotDvtDir.mkdir();
            }
            ArrayList<String> allCmdFileList = new ArrayList<String>(this.fCmdFileList);
            ArrayList<BuildConfigProperty> allProperties = new ArrayList<BuildConfigProperty>();
            ArrayList<String> existingTopFiles = new ArrayList<String>();
            ArrayList<String> existingTestFiles = new ArrayList<String>();
            List<BuildConfigProperty> activeBuildConfigCompactedCachedInfo = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(this.fProject);
            if (activeBuildConfigCompactedCachedInfo != null) {
                allProperties.addAll(activeBuildConfigCompactedCachedInfo);
            }
            for (BuildConfigProperty p : allProperties) {
                if (p.getKind() == 0 && !p.hasAttribute("ATTRIBUTE_TEST_FILE") || p.getKind() == 12) {
                    existingTopFiles.add(p.getValue());
                    continue;
                }
                if (p.getKind() != 0 || !p.hasAttribute("ATTRIBUTE_TEST_FILE")) continue;
                existingTestFiles.add(p.getValue());
            }
            String activeBuildConfig = String.valueOf(BuildConfigManager.getActiveBuildConfigName(this.fProject)) + ".build";
            File activeBuildConfigFile = new File(this.fProject.getLocation().toFile(), ".dvt/" + activeBuildConfig);
            StringBuilder content = new StringBuilder();
            for (IFile file : this.fFiles) {
                String filePath = file.getLocation().toOSString();
                ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
                if (existingTopFiles.contains(filePath) || existingTopFiles.contains(parserPath.path)) {
                    duplicates.add(file.getProjectRelativePath().toOSString());
                    continue;
                }
                if (existingTestFiles.contains(filePath) || existingTestFiles.contains(parserPath.path)) {
                    addedTestFiles.add(file.getProjectRelativePath().toOSString());
                    continue;
                }
                String toAdd = this.getDirective(file, allCmdFileList);
                if (toAdd == null) continue;
                content.append(toAdd);
                added.add(toAdd);
            }
            status = DVTFileUtils.getInstance().writeStringToFileWithCheckout(this.fProject, activeBuildConfigFile, content.toString());
            if (status == 8) {
                throw new OperationCanceledException();
            }
            if (status == 4) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Checkout Error", (String)("Unable to check out " + activeBuildConfigFile.getAbsolutePath()));
            }
            IFolder dvtProjectSettingsFolder = this.fProject.getProject().getFolder(".dvt");
            dvtProjectSettingsFolder.getFile(activeBuildConfig).refreshLocal(1, null);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (status != 0) {
            return null;
        }
        if (!duplicates.isEmpty()) {
            this.popDuplicates(duplicates);
        }
        if (!addedTestFiles.isEmpty()) {
            this.popTestFiles(addedTestFiles);
        }
        if (added.isEmpty()) {
            this.popNothingToAdd();
        } else {
            this.popTriggerRebuild();
        }
        return null;
    }

    private void getCmdFileExtensions() {
        try {
            this.fCmdFileList = this.getExtensions("ro.amiq.dvt.DVTBuildConfigSource");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private List<String> getExtensions(String context) {
        String[] tmpArr = DVTFileUtils.getInstance().getExtensionsForContentType(context, false);
        if (tmpArr == null || tmpArr.length == 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList(tmpArr);
    }

    private String getDirective(IFile file, List<String> allCmdFileList) {
        String fileExtension = Path.fromOSString((String)file.toString()).getFileExtension().toLowerCase();
        String toAdd = allCmdFileList.contains(fileExtension) ? "-f " + (DVTFileUtils.getInstance().isLinked((IResource)file) ? this.getFileNameAbsolute(file) : this.getFileNameRelative(file)) : (DVTFileUtils.getInstance().isLinked((IResource)file) ? this.getFileNameAbsolute(file) : this.getFileNameRelative(file));
        return String.valueOf(NEWLINE) + toAdd;
    }

    private String getFileNameRelative(IFile file) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return file.getProjectRelativePath().toOSString().replaceAll(Matcher.quoteReplacement("\\"), "/");
        }
        return file.getProjectRelativePath().toOSString();
    }

    private String getFileNameAbsolute(IFile file) {
        return file.getLocation().toOSString();
    }

    private void popTestFiles(final List<String> addedTestFiles) {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Test File Added As Top File", null, "The following files you tried to add are already set as Test Files:", 1, new String[]{"OK"}, 0){

            protected Control createCustomArea(Composite parent) {
                parent.setLayout((Layout)new GridLayout());
                org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2560);
                GridData layoutData = new GridData(4, 4, true, true);
                layoutData.heightHint = 100;
                list.setLayoutData((Object)layoutData);
                list.setItems(addedTestFiles.toArray(new String[addedTestFiles.size()]));
                list.setSelection(new String[0]);
                return parent;
            }
        }.open();
    }

    private void popTriggerRebuild() {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Top Files Changed!", null, "You added a new Top File to your project. It is recommended to rebuild for refreshing dictionary, errors etc.", 2, new String[]{"Rebuild Now", "Later"}, 0);
        if (dialog.open() == 0) {
            DVTBuildUtils.runInternalBuilder(this.fProject);
        }
    }

    private void popNothingToAdd() {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Add Top Files Error", null, "There were no files eligible for new Top Files in the selection you made.", 2, new String[]{"OK"}, 0).open();
    }

    private void popDuplicates(final List<String> duplicates) {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Existing Top Files", null, "The following files you tried to add are already set as Top Files:", 2, new String[]{"OK"}, 0){

            protected Control createCustomArea(Composite parent) {
                parent.setLayout((Layout)new GridLayout());
                org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2560);
                GridData layoutData = new GridData(4, 4, true, true);
                layoutData.heightHint = 100;
                list.setLayoutData((Object)layoutData);
                list.setItems(duplicates.toArray(new String[duplicates.size()]));
                list.setSelection(new String[0]);
                return parent;
            }
        }.open();
    }

    private void popError() {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Add Top Files Error", null, this.fErrorMessage, 1, new String[]{"OK"}, 0).open();
    }

    public void checkSelection() {
        try {
            FileEditorInput activeEditorInput;
            Object editorInput;
            this.fFiles.clear();
            this.fProject = null;
            this.fErrorMessage = null;
            Object variable = this.fEvaluationContext.getVariable("activePartId");
            String partId = "";
            if (variable instanceof String) {
                partId = (String)variable;
            }
            if (!partId.isEmpty() && !partId.equals("org.eclipse.ui.views.ResourceNavigator") && !partId.equals("org.eclipse.ui.navigator.ProjectExplorer") && (editorInput = this.fEvaluationContext.getVariable("activeEditorInput")) instanceof FileEditorInput && (activeEditorInput = (FileEditorInput)editorInput) != null) {
                IFile file = activeEditorInput.getFile();
                this.fFiles.add(file);
                this.fProject = file.getProject();
                return;
            }
            ISelection selection = DVTPlugin.getSelectionManager().getLastSelection();
            if (selection instanceof IStructuredSelection) {
                Object[] elements;
                Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!(element instanceof IFile)) {
                        this.fErrorMessage = "You cannot add folders to Top Files!";
                        return;
                    }
                    IFile file = (IFile)element;
                    this.fFiles.add(file);
                    if (this.fProject == null) {
                        this.fProject = file.getProject();
                    } else if (this.fProject != file.getProject()) {
                        this.fErrorMessage = "You have to select files from a single project!";
                        return;
                    }
                    ++n2;
                }
            } else {
                IResource res = DVTPlugin.getSelectionManager().getLastSelectedResource();
                if (res == null) {
                    this.fErrorMessage = "Selection is not valid!";
                    return;
                }
                if (!(res instanceof IFile)) {
                    this.fErrorMessage = "You cannot add folders to topfiles!";
                    return;
                }
                IFile file = (IFile)res;
                this.fFiles.add(file);
                this.fProject = file.getProject();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

