/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.breadcrumb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.pathmanager.DPMListenerManager;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;

public enum BreadcrumbMode {
    DESIGN("Design", DHBreadcrumbViewer.class),
    VERIFICATION("Verification", VHBreadcrumbViewer.class),
    SCOPE("Scope", ScopeBreadcrumbViewer.class),
    FILESYSTEM("Filesystem", FSBreadcrumbViewer.class);

    private final String name;
    private final Class<? extends AbstractBreadcrumbViewer> bCClass;
    private boolean isEnabled;
    private static Set<BreadcrumbMode> breadcrumbModes;
    private static Set<BreadcrumbMode> previousBreadcrumbModes;

    public static void init() {
        try {
            IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = event -> {
                if (!"breadcrumb_type".equals(event.getKey())) {
                    return;
                }
                BreadcrumbMode.refreshBreadcrumbs();
            };
            DVTPlugin.getDefault().getPreferences().addPreferenceChangeListener(preferenceChangeListener);
            BreadcrumbMode.refreshBreadcrumbs();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private BreadcrumbMode(String name, Class<? extends AbstractBreadcrumbViewer> bCClass) {
        this.name = name;
        this.bCClass = bCClass;
    }

    public String getName() {
        return this.name;
    }

    private static void refreshBreadcrumbs() {
        String breadcrumbModePreference = DVTPlugin.getDefault().getPreferenceStore().getString("breadcrumb_type");
        breadcrumbModes = new HashSet<BreadcrumbMode>(BreadcrumbMode.fromCsv(breadcrumbModePreference));
        if (previousBreadcrumbModes == null) {
            BreadcrumbMode.showHideBCTypes();
        } else {
            BreadcrumbMode bcMode = BreadcrumbMode.computeBCChangedMode();
            if (bcMode == null) {
                return;
            }
            BreadcrumbMode.showHideBreadcrumb(bcMode);
        }
        previousBreadcrumbModes = breadcrumbModes;
    }

    private static void showHideBCTypes() {
        if (breadcrumbModes == null) {
            return;
        }
        BreadcrumbMode[] breadcrumbModeArray = BreadcrumbMode.values();
        int n = breadcrumbModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BreadcrumbMode bcMode = breadcrumbModeArray[n2];
            BreadcrumbMode.showHideBreadcrumb(bcMode);
            ++n2;
        }
    }

    private static void showHideBreadcrumb(BreadcrumbMode bcMode) {
        if (breadcrumbModes.contains((Object)bcMode)) {
            bcMode.activate();
            return;
        }
        bcMode.deactivate();
    }

    private static BreadcrumbMode computeBCChangedMode() {
        if (previousBreadcrumbModes == null || breadcrumbModes == null) {
            return null;
        }
        if (previousBreadcrumbModes.size() == breadcrumbModes.size()) {
            return null;
        }
        if (previousBreadcrumbModes.size() > breadcrumbModes.size()) {
            return BreadcrumbMode.computeBreadcrumbDeactivated();
        }
        return BreadcrumbMode.computeBreadcrumbActivated();
    }

    private static BreadcrumbMode computeBreadcrumbActivated() {
        for (BreadcrumbMode breadcrumbMode : breadcrumbModes) {
            if (previousBreadcrumbModes.contains((Object)breadcrumbMode)) continue;
            return breadcrumbMode;
        }
        return null;
    }

    private static BreadcrumbMode computeBreadcrumbDeactivated() {
        for (BreadcrumbMode previousBreadcrumbMode : previousBreadcrumbModes) {
            if (breadcrumbModes.contains((Object)previousBreadcrumbMode)) continue;
            return previousBreadcrumbMode;
        }
        return null;
    }

    public void activate() {
        this.isEnabled = true;
        this.internalActivate();
    }

    public void deactivate() {
        this.isEnabled = false;
        this.internalActivate();
    }

    public void internalActivate() {
        List<IEditorPart> visibleEditors = Utils.computeVisibleEditors();
        if (visibleEditors == null || visibleEditors.isEmpty()) {
            return;
        }
        for (IEditorPart editorPart : visibleEditors) {
            IDVTBreadcrumbHost activeEditor;
            if (!(editorPart instanceof IDVTBreadcrumbHost) || !(activeEditor = (IDVTBreadcrumbHost)editorPart).isValidLangForBreadcrumb(this.bCClass)) continue;
            if (!this.isEnabled) {
                activeEditor.hideBreadcrumb(this.bCClass);
                continue;
            }
            if (this.bCClass == VHBreadcrumbViewer.class) {
                activeEditor.updateBreadcrumb(this.bCClass, null);
                continue;
            }
            if (this.bCClass == FSBreadcrumbViewer.class) {
                activeEditor.updateBreadcrumb(this.bCClass, new FSBreadcrumbConfiguration(null));
                continue;
            }
            if (this.bCClass == DHBreadcrumbViewer.class) {
                if (!(activeEditor instanceof DVTEditor)) {
                    activeEditor.updateBreadcrumb(this.bCClass, new DHBreadcrumbConfiguration(false, 0));
                    continue;
                }
                DHBreadcrumbViewer dhBreadcrumb = (DHBreadcrumbViewer)activeEditor.getBreadcrumbViewer(DHBreadcrumbViewer.class);
                if (dhBreadcrumb == null) continue;
                DPMListenerManager.INSTANCE.notifyListener(dhBreadcrumb, DPMNotification.DPMNotificationKind.FORCE_UPDATE);
                continue;
            }
            if (!(activeEditor instanceof DVTEditor)) continue;
            IRfBreadcrumbElement cursorScopeForBreadcrumb = ((DVTEditor)activeEditor).getCursorScopeForBreadcrumb(true);
            int cursorOffset = ((DVTEditor)activeEditor).getCursor();
            IFile file = (IFile)activeEditor.getEditorInput().getAdapter(IFile.class);
            ScopeBreadcrumbConfiguration configuration = new ScopeBreadcrumbConfiguration(cursorScopeForBreadcrumb, cursorOffset, file, false);
            activeEditor.updateBreadcrumb(this.bCClass, configuration);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static List<BreadcrumbMode> fromCsv(String valuesString) {
        List<String> valuesList = Arrays.asList(valuesString.split(","));
        ArrayList<BreadcrumbMode> availableModes = new ArrayList<BreadcrumbMode>();
        for (String valueString : valuesList) {
            try {
                BreadcrumbMode valueEnum = BreadcrumbMode.valueOf(valueString);
                if (valueEnum == null) continue;
                availableModes.add(valueEnum);
            }
            catch (Exception exception) {}
        }
        return availableModes;
    }
}

