/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.breadcrumb;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;

public class BreadcrumbNavigationHandler
extends AbstractHandler {
    private static final String DH_BREADCRUMB_ID = "ro.amiq.dvt.actions.breadcrumb.SwitchDHBreadcrumbContext";
    private static final String SCOPE_BREADCRUMB_ID = "ro.amiq.dvt.actions.breadcrumb.SwitchScopeBreadcrumbContext";
    private static final String VH_BREADCRUMB_ID = "ro.amiq.dvt.actions.breadcrumb.SwitchVHBreadcrumbContext";
    private static Map<String, Class<? extends AbstractBreadcrumbViewer>> breadcrumbs = new HashMap<String, Class<? extends AbstractBreadcrumbViewer>>();

    static {
        breadcrumbs.put(DH_BREADCRUMB_ID, DHBreadcrumbViewer.class);
        breadcrumbs.put(SCOPE_BREADCRUMB_ID, ScopeBreadcrumbViewer.class);
        breadcrumbs.put(VH_BREADCRUMB_ID, VHBreadcrumbViewer.class);
    }

    public Object execute(ExecutionEvent e) throws ExecutionException {
        Command command = e.getCommand();
        if (command == null) {
            return null;
        }
        String id = command.getId();
        if (id == null || !breadcrumbs.containsKey(id)) {
            return null;
        }
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)e);
        if (!(activeEditor instanceof IDVTBreadcrumbHost)) {
            return null;
        }
        AbstractBreadcrumbViewer viewer = ((IDVTBreadcrumbHost)activeEditor).getBreadcrumbViewer(breadcrumbs.get(e.getCommand().getId()));
        if (viewer == null) {
            return null;
        }
        viewer.deselectItem();
        if (viewer.hasFocus()) {
            viewer.loseFocus();
            activeEditor.setFocus();
            return null;
        }
        viewer.setFocus();
        return null;
    }
}

