/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.breadcrumb;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.pathmanager.DPMListenerManager;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;

public class BreadcrumbStateHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "ro.amiq.dvt.actions.breadcrumb.ToggleBreadcrumb";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HandlerUtil.toggleCommandState((Command)event.getCommand());
        List<IEditorPart> visibleEditors = Utils.computeVisibleEditors();
        if (visibleEditors == null) {
            return null;
        }
        for (IEditorPart editorPart : visibleEditors) {
            IDVTBreadcrumbHost activeEditor;
            if (!(editorPart instanceof IDVTBreadcrumbHost) || !(activeEditor = (IDVTBreadcrumbHost)editorPart).shouldHaveBreadcrumb()) continue;
            if (!BreadcrumbStateHandler.isBreadcrumbEnabled()) {
                activeEditor.hideBreadcrumb(DHBreadcrumbViewer.class);
                activeEditor.hideBreadcrumb(ScopeBreadcrumbViewer.class);
                activeEditor.hideBreadcrumb(VHBreadcrumbViewer.class);
                activeEditor.hideBreadcrumb(FSBreadcrumbViewer.class);
                ObjectionManager.getInstance().clear(Objection.VERIFICATION_BC);
                ObjectionManager.getInstance().clear(Objection.SCOPE_BC);
                ObjectionManager.getInstance().clear(Objection.DESIGN_BC);
                ObjectionManager.getInstance().clear(Objection.FILESYSTEM_BC);
                continue;
            }
            if (!BreadcrumbMode.DESIGN.isEnabled()) {
                activeEditor.hideBreadcrumb(DHBreadcrumbViewer.class);
            } else {
                this.updateDesignBreadcrumb(activeEditor);
            }
            if (!BreadcrumbMode.FILESYSTEM.isEnabled()) {
                activeEditor.hideBreadcrumb(FSBreadcrumbViewer.class);
            } else {
                activeEditor.updateBreadcrumb(FSBreadcrumbViewer.class, new FSBreadcrumbConfiguration(null));
            }
            if (!BreadcrumbMode.VERIFICATION.isEnabled()) {
                activeEditor.hideBreadcrumb(VHBreadcrumbViewer.class);
            } else {
                activeEditor.updateBreadcrumb(VHBreadcrumbViewer.class, null);
            }
            if (!(activeEditor instanceof DVTEditor)) continue;
            if (!BreadcrumbMode.SCOPE.isEnabled()) {
                activeEditor.hideBreadcrumb(ScopeBreadcrumbViewer.class);
                continue;
            }
            IRfBreadcrumbElement cursorScopeForBreadcrumb = ((DVTEditor)activeEditor).getCursorScopeForBreadcrumb(true);
            int cursorOffset = ((DVTEditor)activeEditor).getCursor();
            IFile file = (IFile)activeEditor.getEditorInput().getAdapter(IFile.class);
            ScopeBreadcrumbConfiguration configuration = new ScopeBreadcrumbConfiguration(cursorScopeForBreadcrumb, cursorOffset, file, false);
            activeEditor.updateBreadcrumb(ScopeBreadcrumbViewer.class, configuration);
        }
        return null;
    }

    private void updateDesignBreadcrumb(IDVTBreadcrumbHost activeEditor) {
        if (activeEditor == null) {
            return;
        }
        if (activeEditor instanceof DVTEditor) {
            AbstractBreadcrumbViewer dhBreadcrumb = activeEditor.getBreadcrumbViewer(DHBreadcrumbViewer.class);
            if (!(dhBreadcrumb instanceof DHBreadcrumbViewer)) {
                return;
            }
            DPMListenerManager.INSTANCE.notifyListener((DHBreadcrumbViewer)dhBreadcrumb, DPMNotification.DPMNotificationKind.FORCE_UPDATE);
            return;
        }
        activeEditor.updateBreadcrumb(DHBreadcrumbViewer.class, new DHBreadcrumbConfiguration(false, 0));
    }

    public static boolean isBreadcrumbEnabled() {
        if (Utils.getActiveWorkbenchWindow() == null) {
            return false;
        }
        ICommandService commandService = (ICommandService)Utils.getActiveWorkbenchWindow().getService(ICommandService.class);
        ParameterizedCommand actualCommand = ParameterizedCommand.generateCommand((Command)commandService.getCommand(COMMAND_ID), null);
        State state = actualCommand.getCommand().getState("org.eclipse.ui.commands.toggleState");
        if (state.getValue() instanceof Boolean) {
            return (Boolean)state.getValue();
        }
        return false;
    }
}

