/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.editor.fonts;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import ro.amiq.dvt.startup.core.DVTLogger;

public class FontUtils {
    private static final String[] ALL_FONT_PREFERENCES = new String[]{"com.perforce.team.ui.consoleFont", "org.eclipse.cdt.debug.ui.ModulesDetailPaneFont", "org.eclipse.cdt.internal.ui.compare.AsmMergeViewer", "org.eclipse.cdt.internal.ui.compare.CMergeViewer", "org.eclipse.cdt.make.internal.ui.compare.MakefileMergeViewer", "org.eclipse.cdt.ui.buildconsole.ConsoleFont", "org.eclipse.cdt.ui.editors.textfont", "org.eclipse.compare.contentmergeviewer.TextMergeViewer", "org.eclipse.debug.ui.DetailPaneFont", "org.eclipse.debug.ui.MemoryViewTableFont", "org.eclipse.debug.ui.consoleFont", "org.eclipse.dltk.debug.ui.dbgpLogView.txtViewFont", "org.eclipse.dltk.ruby.internal.ui.compare.RubyMergeViewer", "org.eclipse.dltk.tcl.internal.ui.compare.TclMergeViewer", "org.eclipse.egit.ui.CommitMessageEditorFont", "org.eclipse.egit.ui.CommitMessageFont", "org.eclipse.egit.ui.DiffHeadlineFont", "org.eclipse.jdt.internal.ui.compare.JavaMergeViewer", "org.eclipse.jdt.internal.ui.compare.PropertiesFileMergeViewer", "org.eclipse.jdt.ui.PropertiesFileEditor.textfont", "org.eclipse.jdt.ui.editors.textfont", "org.eclipse.jface.textfont", "org.eclipse.ui.workbench.texteditor.blockSelectionModeFont", "org.eclipse.wst.sse.ui.textfont", "pref_console_font", "preference.console.font", "ro.amiq.dvt.ui.console.buildConsoleFont", "ro.amiq.edt.ui.editor.textfont", "ro.amiq.pssdt.ui.editor.textfont", "ro.amiq.msdldt.ui.editor.textfont", "ro.amiq.slndt.ui.editor.textfont", "ro.amiq.vhdldt.ui.editor.textfont", "ro.amiq.vlogdt.ui.editor.textfont", "terminal.views.view.font.definition"};

    static void increaseFont() {
        FontUtils.changeFont(1);
    }

    static void decreaseFont() {
        FontUtils.changeFont(-1);
    }

    private static void changeFont(int changeBy) {
        try {
            IEclipsePreferences workbenchPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
            IEclipsePreferences defaultPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.ui.workbench");
            String[] stringArray = ALL_FONT_PREFERENCES;
            int n = ALL_FONT_PREFERENCES.length;
            int n2 = 0;
            while (n2 < n) {
                int newSize;
                FontData[] fontData;
                String fontPreference = stringArray[n2];
                String value = workbenchPreferences.get(fontPreference, null);
                if (value == null) {
                    value = defaultPreferences.get(fontPreference, null);
                }
                if (value != null && (fontData = PreferenceConverter.basicGetFontData((String)value)) != null && fontData.length != 0 && (newSize = fontData[0].getHeight() + changeBy) >= 3 && newSize <= 64) {
                    fontData[0].setHeight(newSize);
                    workbenchPreferences.put(fontPreference, fontData[0].toString());
                }
                ++n2;
            }
            workbenchPreferences.flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static FontData setFont(FontData fontData) {
        FontData result = null;
        try {
            ScopedPreferenceStore workbenchPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.workbench");
            String[] stringArray = ALL_FONT_PREFERENCES;
            int n = ALL_FONT_PREFERENCES.length;
            int n2 = 0;
            while (n2 < n) {
                String fontPreference = stringArray[n2];
                if (fontData == null) {
                    workbenchPreferences.setToDefault(fontPreference);
                } else {
                    workbenchPreferences.setValue(fontPreference, fontData.toString());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FontData getFont() {
        FontData fontData;
        FontData result = null;
        try {
            IEclipsePreferences workbenchPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
            IEclipsePreferences defaultPreferences = DefaultScope.INSTANCE.getNode("org.eclipse.ui.workbench");
            String[] stringArray = ALL_FONT_PREFERENCES;
            int n = ALL_FONT_PREFERENCES.length;
            int n2 = 0;
            while (true) {
                FontData[] fontData2;
                if (n2 >= n) {
                    workbenchPreferences.flush();
                    break;
                }
                String fontPreference = stringArray[n2];
                String value = workbenchPreferences.get(fontPreference, null);
                if (value == null) {
                    value = defaultPreferences.get(fontPreference, null);
                }
                if (value != null && (fontData2 = PreferenceConverter.basicGetFontData((String)value)) != null && fontData2.length != 0) {
                    if (result == null) {
                        result = fontData2[0];
                    } else if (!result.equals((Object)fontData2[0])) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (result == null) {
            fontData = new FontData();
            return fontData;
        }
        fontData = result;
        return fontData;
    }
}

