/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.history;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryItem;

public abstract class HistoryAction
extends Action {
    private ArrayList<HistoryItem> fElements = new ArrayList();
    public static final int MAX_ENTRIES = 10;
    public static final int MAX_DROPDOWN_ENTRIES = 5;

    public HistoryAction(String text, String tooltip, ImageDescriptor id) {
        super(text, 4);
        this.setImageDescriptor(id);
        this.setToolTipText(tooltip);
        this.setMenuCreator(new MenuCreator());
    }

    public HistoryAction() {
        this("Show History List", "Show History List", DVTImages.HISTORY_LIST);
    }

    public synchronized void addElement(HistoryItem element) {
        if (this.fElements.contains(element)) {
            this.fElements.add(0, this.fElements.remove(this.fElements.indexOf(element)));
        } else {
            this.fElements.add(0, element);
            if (this.fElements.size() > 10) {
                this.fElements.remove(this.fElements.size() - 1);
            }
        }
    }

    public HistoryItem getElement(int index) {
        try {
            return this.fElements.get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void run() {
        new HistoryPopUp(this.getAShell()).open();
    }

    private Shell getAShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    public abstract void openHistoryItem(HistoryItem var1);

    public abstract boolean checkHistoryItem(HistoryItem var1);

    class HistoryItemAction
    extends Action {
        HistoryItem fHistoryItem;

        public HistoryItemAction(HistoryItem historyItem) {
            super(String.valueOf(historyItem.hasUVMElabModel() ? "[UVM Runtime Elaboration] " : "") + historyItem.getText().replace('@', ' '), 32);
            this.fHistoryItem = historyItem;
        }

        public void run() {
            HistoryAction.this.openHistoryItem(this.fHistoryItem);
        }

        public ImageDescriptor getImageDescriptor() {
            if (this.fHistoryItem.getLanguage() == LanguageKind.E) {
                return DVTImages.E_PERSPECTIVE;
            }
            if (this.fHistoryItem.getLanguage() == LanguageKind.VLOG) {
                return DVTImages.VLOG_PERSPECTIVE;
            }
            if (this.fHistoryItem.getLanguage() == LanguageKind.VHDL) {
                return DVTImages.VHDL_PERSPECTIVE;
            }
            if (this.fHistoryItem.getLanguage() == LanguageKind.SLN) {
                return DVTImages.SLN_PERSPECTIVE;
            }
            if (this.fHistoryItem.getLanguage() == LanguageKind.PSS) {
                return DVTImages.PSS_PERSPECTIVE;
            }
            if (this.fHistoryItem.getLanguage() == LanguageKind.MSDL) {
                return DVTImages.SDL_PERSPECTIVE;
            }
            return super.getImageDescriptor();
        }
    }

    public class HistoryPopUp
    extends PopupDialog {
        private List fList;

        public HistoryPopUp(Shell shell) {
            super(shell, 16, true, true, true, true, true, " History List", null);
        }

        private synchronized void handleDoubleClick() {
            int idx = this.fList.getSelectionIndex();
            if (idx != -1) {
                HistoryAction.this.openHistoryItem(HistoryAction.this.fElements.get(idx));
            }
            this.close();
        }

        protected synchronized Control createDialogArea(Composite parent) {
            Composite entryTable = (Composite)super.createDialogArea(parent);
            this.fList = new List(entryTable, 772);
            this.fList.setFont(parent.getFont());
            GridData data = new GridData(1808);
            this.fList.setLayoutData((Object)data);
            data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.heightHint = this.fList.getItemHeight() * 10;
            data.widthHint = 300;
            entryTable.setLayoutData((Object)data);
            entryTable.setLayout((Layout)new GridLayout());
            int i = 0;
            while (i < HistoryAction.this.fElements.size()) {
                if (!HistoryAction.this.checkHistoryItem(HistoryAction.this.fElements.get(i))) {
                    HistoryAction.this.fElements.remove(i);
                    --i;
                } else {
                    HistoryItem historyItem = HistoryAction.this.fElements.get(i);
                    this.fList.add(String.valueOf(historyItem.hasUVMElabModel() ? "[UVM Runtime Elaboration] " : "") + historyItem.getText().replace('@', ' '));
                }
                ++i;
            }
            this.fList.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    HistoryPopUp.this.handleDoubleClick();
                }
            });
            return entryTable;
        }
    }

    class MenuCreator
    implements IMenuCreator {
        Menu fMenu;

        MenuCreator() {
        }

        public synchronized Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            ActionContributionItem item = null;
            int i = 0;
            while (i < HistoryAction.this.fElements.size()) {
                if (i >= 5) break;
                if (!HistoryAction.this.checkHistoryItem(HistoryAction.this.fElements.get(i))) {
                    HistoryAction.this.fElements.remove(i);
                    --i;
                } else {
                    HistoryItemAction myAction = new HistoryItemAction(HistoryAction.this.fElements.get(i));
                    item = new ActionContributionItem((IAction)myAction);
                    item.fill(this.fMenu, -1);
                }
                ++i;
            }
            if (HistoryAction.this.fElements.size() > 5) {
                new MenuItem(this.fMenu, 2);
                item = new ActionContributionItem((IAction)new Action("More..."){

                    public void run() {
                        new HistoryPopUp(HistoryAction.this.getAShell()).open();
                    }
                });
                item.fill(this.fMenu, -1);
            }
            new MenuItem(this.fMenu, 2);
            item = new ActionContributionItem((IAction)new Action("Clear History"){

                public void run() {
                    ((MenuCreator)MenuCreator.this).HistoryAction.this.fElements.clear();
                }
            });
            item.fill(this.fMenu, -1);
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

