/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.nature;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;

public class ChangeProjectNatureAction
implements IObjectActionDelegate {
    private IProject project = null;

    public void run(IAction action) {
        if (this.project == null) {
            return;
        }
        LinkedList<INatureContributor> initialSelection = new LinkedList<INatureContributor>();
        for (INatureContributor contributor : NatureContributors.getContributors()) {
            if (!contributor.hasNature(this.project)) continue;
            initialSelection.add(contributor);
        }
        ChangeProjectNatureDialog dialog = new ChangeProjectNatureDialog(initialSelection);
        if (dialog.open() == 0) {
            List<Object> resultSelection = Arrays.asList(dialog.getResult());
            for (INatureContributor contributor : NatureContributors.getContributors()) {
                boolean initial = initialSelection.contains(contributor);
                boolean result = resultSelection.contains(contributor);
                if (initial && !result) {
                    contributor.deactivateNature(this.project);
                    continue;
                }
                if (initial || !result) continue;
                contributor.activateNature(this.project);
            }
            DVTPlugin.getDefault().collect().z();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        String perspectiveID = null;
        boolean enabled = false;
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            this.project = obj == null ? null : (obj instanceof IProject ? (IProject)obj : (obj instanceof IResource ? ((IResource)obj).getProject() : (IProject)((IAdaptable)obj).getAdapter(IProject.class)));
        }
        try {
            perspectiveID = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
        }
        catch (Exception exception) {
            perspectiveID = null;
        }
        if (perspectiveID != null && this.project != null && this.project.isOpen()) {
            enabled = true;
        }
        action.setEnabled(enabled);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    static class ChangeProjectNatureDialog
    extends ListSelectionDialog {
        private static final String SELECT_MESSAGE = "Select the nature(s) for this project:";
        private static final String TCL_INFO_MESSAGE = "TCL plugin is not installed.";
        private static final String INFO_TOOLTIP = JFaceResources.getString((String)"info");
        private static final Image INFO_IMAGE = JFaceResources.getImage((String)"dialog_messasge_info_image");
        private static final LabelProvider LABEL_PROVIDER = new LabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof INatureContributor) {
                    return ((INatureContributor)element).getName();
                }
                return super.getText(element);
            }
        };
        private CheckboxTableViewer fViewer;
        private Composite infoComposite;
        private Label infoLabel;
        private Label iconLabel;

        public ChangeProjectNatureDialog(List<INatureContributor> initialSelection) {
            super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), NatureContributors.getContributors(), (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)LABEL_PROVIDER, SELECT_MESSAGE);
            this.setTitle("Change Project Nature");
            this.setInitialElementSelections(initialSelection);
            this.setHelpAvailable(false);
        }

        protected Control createDialogArea(Composite parent) {
            int size;
            Control result = super.createDialogArea(parent);
            this.infoComposite = new Composite(parent, 0);
            this.infoComposite.setLayout((Layout)new GridLayout(2, false));
            this.infoComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.iconLabel = new Label(this.infoComposite, 0);
            this.iconLabel.setFont(parent.getFont());
            this.iconLabel.setImage(null);
            this.infoLabel = new Label(this.infoComposite, 0);
            this.infoLabel.setFont(parent.getFont());
            this.infoLabel.setText("");
            this.fViewer = this.getViewer();
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    this.update();
                    this.validate();
                }
            });
            Object data = this.fViewer.getTable().getLayoutData();
            if (data instanceof GridData && (size = this.convertHeightInCharsToPixels(NatureContributors.getContributors().size() + 2)) > 0) {
                ((GridData)data).heightHint = size;
            }
            return result;
        }

        private void update() {
            if (this.fViewer.getChecked((Object)NatureContributors.getContributor(LanguageKind.CPP_EXT))) {
                this.fViewer.setChecked((Object)NatureContributors.getContributor(LanguageKind.CPP), true);
            }
        }

        protected void validate() {
            if (this.fViewer == null) {
                return;
            }
            Object[] checkedElements = this.fViewer.getCheckedElements();
            if (checkedElements == null) {
                return;
            }
            boolean hasDesign = false;
            boolean hasPf = false;
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageKind lk;
                Object o = objectArray[n2];
                if (o instanceof INatureContributor && (lk = ((INatureContributor)o).getLanguageKind()) != null) {
                    if (lk == LanguageKind.VHDL || lk == LanguageKind.VLOG) {
                        hasDesign = true;
                    }
                    if (lk == LanguageKind.PF) {
                        boolean hasTclPluginInstalled;
                        hasPf = true;
                        boolean bl = hasTclPluginInstalled = Platform.getBundle((String)"org.eclipse.dltk.tcl.core") != null;
                        if (!hasTclPluginInstalled) {
                            this.updatePFLabel(TCL_INFO_MESSAGE, INFO_TOOLTIP, INFO_IMAGE);
                        } else {
                            this.updatePFLabel("", "", null);
                        }
                    }
                }
                ++n2;
            }
            if (!hasPf) {
                this.updatePFLabel("", "", null);
            }
            this.getOkButton().setEnabled(!hasPf || hasDesign);
        }

        private void updatePFLabel(String infoMessage, String tooltipMessage, Image image) {
            this.iconLabel.setImage(image);
            this.iconLabel.setToolTipText(tooltipMessage);
            this.infoLabel.setText(infoMessage);
            this.infoLabel.getParent().layout();
        }
    }
}

