/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.actions.quickhelp;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.actions.quickhelp.QuickHelpUtils;

public class ShowHelpPage
extends AbstractHandler {
    private static final String DEFAULT_NATURE = "ro.amiq.vlogdt.VlogNature";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPerspectiveDescriptor iPerspectiveDescriptor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
        if (iPerspectiveDescriptor == null) {
            return null;
        }
        String category = event.getCommand().getId();
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        String nature = "";
        if (project == null || !project.isAccessible()) {
            String perspectiveId = iPerspectiveDescriptor.getId();
            if (perspectiveId.equals("ro.amiq.dvt.ui.perspectives.DVTPerspective")) {
                nature = DEFAULT_NATURE;
            } else if (perspectiveId.equals("ro.amiq.vlogdt.ui.perspectives.VlogPerspective")) {
                nature = DEFAULT_NATURE;
            } else if (perspectiveId.equals("ro.amiq.edt.ui.perspectives.EDTPerspective")) {
                nature = "ro.amiq.edt.enature";
            } else if (perspectiveId.equals("ro.amiq.slndt.ui.perspectives.SLNDTPerspective")) {
                nature = "ro.amiq.slndt.slnnature";
            } else if (perspectiveId.equals("ro.amiq.pssdt.ui.perspectives.PSSPerspective")) {
                nature = "ro.amiq.pssdt.pssnature";
            } else if (perspectiveId.equals("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective")) {
                nature = "ro.amiq.vhdldt.VhdlNature";
            }
        } else {
            try {
                if (project.hasNature("ro.amiq.edt.enature")) {
                    nature = "ro.amiq.edt.enature";
                } else if (project.hasNature(DEFAULT_NATURE)) {
                    nature = DEFAULT_NATURE;
                } else if (project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                    nature = "ro.amiq.vhdldt.VhdlNature";
                } else if (project.hasNature("ro.amiq.slndt.slnnature")) {
                    nature = "ro.amiq.slndt.slnnature";
                } else if (project.hasNature("ro.amiq.pssdt.pssnature")) {
                    nature = "ro.amiq.pssdt.pssnature";
                }
            }
            catch (Exception exception) {}
        }
        if (nature.isEmpty()) {
            return null;
        }
        String path = QuickHelpUtils.getHelpSectionPath(nature, category);
        if (!path.isEmpty()) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(path);
        }
        return null;
    }
}

