/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import ro.amiq.dvt.ui.buildconfig.editor.BCStyle;
import ro.amiq.dvt.ui.buildconfig.editor.IBCConstants;
import ro.amiq.dvt.ui.buildconfig.editor.rules.BCKeywordRule;
import ro.amiq.dvt.ui.buildconfig.editor.rules.BCWhitespaceDetector;
import ro.amiq.dvt.ui.buildconfig.editor.rules.BCWordDetector;

public class BCCodeScanner
extends BufferedRuleBasedScanner {
    public BCCodeScanner(BCStyle style, boolean enable) {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new BCWhitespaceDetector()));
        String[] words = (String[])Arrays.stream(IBCConstants.ALL_DVT_DIRECTIVES.split(";")).filter(x -> !x.isEmpty()).map(x -> Character.isJavaIdentifierPart(x.charAt(0)) ? x : x.substring(1)).toArray(String[]::new);
        rules.add(new BCKeywordRule(words, style.getToken("highlight.keyword"), enable));
        rules.add(new WordRule((IWordDetector)new BCWordDetector(), style.getToken("highlight.default")));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLineOfOffset(int offset) {
        try {
            return this.fDocument.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void unreadLength(int length) {
        int i = length - 1;
        while (i >= 0) {
            this.unread();
            --i;
        }
    }

    public void dispose() {
        this.fDocument = null;
    }
}

