/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.CopyFileInfoAction;
import ro.amiq.dvt.ui.actions.CopyFileInfoKind;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditorCommon;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditorMessages;
import ro.amiq.dvt.ui.buildconfig.editor.BCSourceViewerConfiguration;
import ro.amiq.dvt.ui.buildconfig.editor.actions.BCOpenFileAction;
import ro.amiq.dvt.ui.buildconfig.editor.actions.ToggleCommentAction;
import ro.amiq.dvt.ui.editor.DVTContentAssistAction;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.actions.ShowIncludingFileAction;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.BCSemanticHighlighter;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.search.ui.IBaseShowConstraintsAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowEmittersAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.DVTHelpListener;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.buildconfig.DefaultBuildConfigGenerator;

public class BCEditor
extends BCEditorCommon {
    private static final String HELP = ".help";
    private static final String HELP_HREF = "HELP";
    private static final String INFO_LABEL = "<a href=\"HELP\">Build configuration quick reference...</a>";
    public static final String TOGGLE_COMMENT = "ro.amiq.dvt.ui.buildconfig.editor.ToggleComment";
    public static final String OPEN_FILE = "ro.amiq.dvt.ui.buildconfig.editor.OpenFile";
    public static final String COPY_FULL_PATH = "ro.amiq.dvt.ui.editor.CopyFullPath";
    public static final String COPY_FILE_NAME = "ro.amiq.dvt.ui.editor.CopyFileName";
    public static final String SHOW_INCLUDING_FILE = "ro.amiq.dvt.ui.editor.ShowIncludingFile";

    public BCEditor() {
        this.createEditorConfiguration();
    }

    protected void createEditorConfiguration() {
        super.createEditorConfiguration(this);
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        DVTPlugin.getDefault().getWorkbench().getDecoratorManager().addListener((ILabelProviderListener)this);
    }

    @Override
    public void createPartControl(Composite parent) {
        Control[] children;
        StyledText textWidget;
        if (!this.isShowingHelpFile()) {
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(container);
            Composite linkWrapper4Margins = new Composite(container, 0);
            GridLayoutFactory.fillDefaults().spacing(0, 0).margins(5, 5).applyTo(linkWrapper4Margins);
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)linkWrapper4Margins);
            Composite linkWrapper4Border = new Composite(linkWrapper4Margins, 2048);
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(linkWrapper4Border);
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)linkWrapper4Border);
            DVTColorUtil.INSTANCE.setBackground((Control)linkWrapper4Border, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor"));
            DVTColorUtil.INSTANCE.setForeground((Control)linkWrapper4Border, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"));
            Link link = new Link(linkWrapper4Border, 4);
            GridDataFactory.fillDefaults().align(0x1000000, 128).grab(true, false).applyTo((Control)link);
            link.setText(INFO_LABEL);
            DVTUiUtils.setPlatformLinkColor((Link)link);
            DVTColorUtil.INSTANCE.setBackground((Control)link, DVTColorUtil.INSTANCE.getBackground((Control)link.getParent()));
            link.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (BCEditor.HELP_HREF.equals(e.text)) {
                        IFile file = (IFile)BCEditor.this.getAdapter(IResource.class);
                        if (file == null) {
                            return;
                        }
                        IProject project = file.getProject();
                        DefaultBuildConfigGenerator generator = BCEditor.getDefaultBuildConfigGenerator(project);
                        String fileName = String.valueOf(BuildConfigManager.getActiveBuildConfigName(project)) + ".build" + BCEditor.HELP;
                        generator.writeFile(project.getLocation().toFile(), fileName);
                        try {
                            project.getFolder(".dvt/").refreshLocal(2, null);
                            IFile helpFile = project.getFile(".dvt/" + fileName);
                            IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActivePage(), (IFile)helpFile, (String)"ro.amiq.dvt.ui.editor.BuildConfigEditor");
                        }
                        catch (CoreException e1) {
                            DVTLogger.INSTANCE.logError((Throwable)e1);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Composite newParent = new Composite(container, 0);
            newParent.setLayout((Layout)new FillLayout(256));
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)newParent);
            super.createPartControl(newParent);
        } else {
            super.createPartControl(parent);
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null && (textWidget = sourceViewer.getTextWidget()) != null) {
            textWidget.addHelpListener((HelpListener)DVTHelpListener.getInstance());
        }
        if ((children = parent.getChildren()).length == 2 && children[0] instanceof Group) {
            children[1].setLayoutData((Object)new GridData(4, 4, true, true));
        }
        this.setupEditorDropTarget();
    }

    private boolean isShowingHelpFile() {
        IFile inputFile = (IFile)this.getAdapter(IResource.class);
        return inputFile != null && inputFile.getName().endsWith(HELP);
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
    }

    private void setupEditorDropTarget() {
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        DropTarget dropTarget = (DropTarget)textWidget.getData("DropTarget");
        if (dropTarget == null) {
            dropTarget = new DropTarget((Control)textWidget, 1);
        }
        dropTarget.setTransfer(new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new ResourceDropListener(textWidget));
        dropTarget.addDropListener((DropTargetListener)new FileDropListener(textWidget));
    }

    private boolean appendDirective(StringBuilder result, IPath draggedResourceLocation) {
        IPath projectLocation = this.getProject().getLocation();
        if (projectLocation == null) {
            return false;
        }
        IPath draggedResRelPath = draggedResourceLocation.makeRelativeTo(projectLocation);
        if (draggedResRelPath == null) {
            return false;
        }
        result.append(draggedResRelPath.toPortableString());
        if (draggedResourceLocation.toFile().isDirectory()) {
            result.append("/**/*");
        }
        return true;
    }

    private void insertDraggedElementPath(String text) {
        try {
            int caretOffset = this.getCursor();
            IEditorInput editorInput = this.getEditorInput();
            IDocument doc = this.getDocumentProvider().getDocument((Object)editorInput);
            if (doc == null) {
                return;
            }
            String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this);
            IRegion lineInfo = doc.getLineInformationOfOffset(caretOffset);
            if (lineInfo == null) {
                return;
            }
            if (lineInfo.getOffset() == caretOffset) {
                doc.replace(caretOffset, 0, String.valueOf(text) + lineDelimiter);
            } else {
                doc.replace(lineInfo.getOffset() + lineInfo.getLength(), 0, String.valueOf(lineDelimiter) + text);
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        TextEditorAction a = new DVTContentAssistAction(BCEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        this.markAsContentDependentAction("ContentAssistProposal", true);
        a = new ToggleCommentAction(BCEditorMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COMMENT);
        this.setAction("ToggleComment", (IAction)a);
        this.setActionActivationCode("ToggleComment", '/', -1, 262144);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        a = new BCOpenFileAction(BCEditorMessages.getResourceBundle(), "OpenFile.", (ITextEditor)this);
        a.setActionDefinitionId(OPEN_FILE);
        this.setAction("OpenFile", (IAction)a);
        a = new CopyFileInfoAction(BCEditorMessages.getResourceBundle(), "CopyFullPath.", (ITextEditor)this, CopyFileInfoKind.COPY_FULL_PATH);
        a.setActionDefinitionId(COPY_FULL_PATH);
        this.setAction("CopyFullPath", (IAction)a);
        a = new CopyFileInfoAction(BCEditorMessages.getResourceBundle(), "CopyFileName.", (ITextEditor)this, CopyFileInfoKind.COPY_FILE_NAME);
        a.setActionDefinitionId(COPY_FILE_NAME);
        this.setAction("CopyFileName", (IAction)a);
        a = new ShowIncludingFileAction(BCEditorMessages.getResourceBundle(), "ShowIncludingFile.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_INCLUDING_FILE);
        this.setAction("ShowIncludingFile", (IAction)a);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"ro.amiq.dvt.ui.buildconfig.editor"});
    }

    @Override
    public void doSetInput(IEditorInput input) throws CoreException {
        try {
            super.doSetInput(input);
            IDocumentExtension3 extension3 = (IDocumentExtension3)this.getDocument();
            if (extension3.getDocumentPartitioner("__BC_partitioning") == null) {
                this.fSourceViewerConfiguration.setupDocumentPartitioner(this.getDocument());
            }
            this.setPrefStore(DVTPlugin.getDefault().getPreferenceStore());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void configureProjectionSupport(ProjectionSupport projectionSupport) {
    }

    @Override
    public void configureSourceViewerConfiguration(ProjectionAnnotationModel annotationModel) {
    }

    @Override
    public TextEditorAction testGetReferencesInWorkspaceAction() {
        return null;
    }

    @Override
    public TextEditorAction testGetReferencesInFileAction() {
        return null;
    }

    @Override
    public DVTSourceViewerConfiguration testGetSourceViewerConfiguration() {
        return null;
    }

    @Override
    public IRfNamedElementAndScope testGetNamedElementAndScopeAtPosition(int line, int column) {
        return null;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        MenuManager submenu = new MenuManager("Edit", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.CUT);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.COPY);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.PASTE);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.UNDO);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.REDO);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "CopyFileName");
        this.addAction((IMenuManager)submenu, "CopyFullPath");
        submenu = new MenuManager("Source", null, null);
        this.addAction((IMenuManager)submenu, "QuickAssist");
        submenu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "ToggleComment");
        this.addAction(menu, "ShowIncludingFile");
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
    }

    @Override
    public void dispose() {
        try {
            try {
                TextEditorAction action;
                ProjectionViewer viewer;
                BCSourceViewerConfiguration configuration = (BCSourceViewerConfiguration)this.getSourceViewerConfiguration();
                if (configuration != null) {
                    configuration.dispose();
                }
                if ((viewer = (ProjectionViewer)this.getSourceViewer()) != null) {
                    viewer.unconfigure();
                    viewer.setProjectionSummary(null);
                }
                if ((action = (TextEditorAction)this.getAction("ToggleComment")) != null) {
                    action.setEditor(null);
                }
                DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
                this.fPreferenceListener = null;
                DVTPlugin.getDefault().getWorkbench().getDecoratorManager().removeListener((ILabelProviderListener)this);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    @Override
    protected IPreferenceStore getPluginSpecificPreferenceStore() {
        return DVTPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public boolean shouldUpdateMarkersOnOpen() {
        return false;
    }

    @Override
    public IBaseShowConstraintsAction testGetShowConstraintsAction() {
        return null;
    }

    @Override
    public IBaseShowEmittersAction testGetShowEmittersAction() {
        return null;
    }

    @Override
    public void showContentAssistProposalsForCreatedFile() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((BCSourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            contAss.showPossibleCompletions();
        });
    }

    public Image getTitleImage() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        Image image = super.getTitleImage();
        try {
            if (file == null) {
                image = DVTImages.imageCache.getImage(DVTImages.DESC_BC_MODULE_GRAY);
            } else {
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        image = DVTImages.imageCache.getImage(DVTImages.DESC_BC_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
                Image newImage = ProjectColorUtils.transformImage(DVTImages.DESC_BC_MODULE_BLACK_TRANSPARENT, file.getProject().getName());
                image = newImage == null ? image : newImage;
            }
            ILabelDecorator decorator = DVTPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
            if (decorator != null) {
                return decorator.decorateImage(image, (Object)this);
            }
        }
        catch (Exception exception) {}
        return image;
    }

    @Override
    public boolean isHoverDisabled() {
        return false;
    }

    @Override
    protected void installSubmenuActions() {
    }

    @Override
    public IBaseShowInstancesAction testGetShowInstancesAction() {
        return null;
    }

    @Override
    public void setFocus() {
        this.recomputeHighlightPositionsAndInvalidateEditor();
        super.setFocus();
    }

    @Override
    public void recomputeHighlightPositionsAndInvalidateEditor() {
        DVTHlUtils.startHighlight(null, this, new BCSemanticHighlighter(this.getDocument()), DVTPlugin.getDefault(), null);
    }

    @Override
    public AbstractBreadcrumbUtils getBreadcrumbUtils(Class<?> breadcrumbType) {
        if (breadcrumbType == FSBreadcrumbViewer.class) {
            return FSBreadcrumbUtils.getInstance();
        }
        return null;
    }

    @Override
    public QuickLazyOutlineView createQuickOutlineView() {
        return null;
    }

    @Override
    public IRfScopeElement getCursorScope() {
        return null;
    }

    @Override
    public DVTSourceViewerConfiguration makeSourceViewerConfiguration() {
        return null;
    }

    @Override
    public DVTLazyOutlinePage getOutlinePage() {
        return null;
    }

    @Override
    public void detectIndentation() {
    }

    private abstract class DropListener
    extends StyledTextDropTargetEffect {
        private DropListener(StyledText textWidget) {
            super(textWidget);
        }

        public abstract boolean isSupported(DropTargetEvent var1);

        public void dragEnter(DropTargetEvent event) {
            if (!this.isSupported(event)) {
                return;
            }
            event.detail = 1;
            event.feedback |= 9;
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.dragEnter(event);
        }

        public void dragOver(DropTargetEvent event) {
            if (!this.isSupported(event)) {
                return;
            }
            event.detail = 1;
            event.feedback |= 9;
            super.dragOver(event);
        }

        public void drop(DropTargetEvent event) {
            this.handle(this.toArray(event.data));
        }

        protected abstract List<IPath> toArray(Object var1);

        private void handle(List<IPath> paths) {
            if (paths.isEmpty()) {
                return;
            }
            String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)BCEditor.this);
            StringBuilder concatResourcesPath = new StringBuilder();
            int i = 0;
            while (i < paths.size() - 1) {
                if (BCEditor.this.appendDirective(concatResourcesPath, paths.get(i))) {
                    concatResourcesPath.append(lineDelimiter);
                }
                ++i;
            }
            if (!BCEditor.this.appendDirective(concatResourcesPath, paths.get(i))) {
                return;
            }
            BCEditor.this.insertDraggedElementPath(concatResourcesPath.toString());
        }
    }

    private class FileDropListener
    extends DropListener {
        public FileDropListener(StyledText textWidget) {
            super(textWidget);
        }

        @Override
        public boolean isSupported(DropTargetEvent event) {
            return FileTransfer.getInstance().isSupportedType(event.currentDataType);
        }

        @Override
        protected List<IPath> toArray(Object data) {
            if (!(data instanceof String[])) {
                return Collections.emptyList();
            }
            ArrayList<IPath> result = new ArrayList<IPath>();
            String[] stringArray = (String[])data;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pathString = stringArray[n2];
                result.add(Path.fromOSString((String)pathString));
                ++n2;
            }
            return result;
        }
    }

    private class ResourceDropListener
    extends DropListener {
        public ResourceDropListener(StyledText textWidget) {
            super(textWidget);
        }

        @Override
        public boolean isSupported(DropTargetEvent event) {
            return ResourceTransfer.getInstance().isSupportedType(event.currentDataType);
        }

        @Override
        protected List<IPath> toArray(Object data) {
            if (!(data instanceof IResource[])) {
                return Collections.emptyList();
            }
            ArrayList<IPath> result = new ArrayList<IPath>();
            IResource[] iResourceArray = (IResource[])data;
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IPath draggedResourceLocation;
                    block5: {
                        IResource resource = iResourceArray[n2];
                        draggedResourceLocation = resource.getLocation();
                        if (draggedResourceLocation != null) break block5;
                        if (!resource.isLinked() || resource.getName().equals("DVT Auto-Linked")) break block6;
                        draggedResourceLocation = DVTFileUtils.getInstance().resolveAutoLinkPath(resource);
                    }
                    result.add(draggedResourceLocation);
                }
                ++n2;
            }
            return result;
        }
    }
}

