/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;

public class BCReconciler
extends DefaultDamagerRepairer {
    ITextViewer fTextViewer;

    public BCReconciler(ITokenScanner scanner, ITextViewer textViewer) {
        super(scanner);
        this.fTextViewer = textViewer;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        try {
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (!documentPartitioningChanged) {
                int inserted = e.getText() == null ? 0 : e.getText().length();
                int removed = e.getLength();
                int offset = e.getOffset();
                if (inserted >= 0 || removed >= 0) {
                    int start = Math.max(removed > 0 ? offset - 1 : offset, partitionStart);
                    int line = this.fDocument.getLineOfOffset(start);
                    start = this.fDocument.getLineOffset(line);
                    int end = Math.min(offset + inserted, partitionEnd);
                    line = this.fDocument.getLineOfOffset(end);
                    end = this.fDocument.getLineOffset(line) + this.fDocument.getLineLength(line);
                    if ((end = Math.min(end, partitionEnd)) > (start = Math.max(start, partitionStart))) {
                        return new TypedRegion(start, end - start, partition.getType());
                    }
                    return partition;
                }
            }
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
            return partition;
        }
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        ITypedRegion newRegion = Utils.limitTypedRegionToVisibleArea(region, this.fTextViewer);
        if (newRegion != null) {
            region = newRegion;
        }
        this.removeDelimiters("__dvt_folding_position", region.getOffset(), region.getOffset() + region.getLength());
        super.createPresentation(presentation, region);
    }

    protected void removeDelimiters(String category, int start, int end) {
        try {
            if (!this.fDocument.containsPositionCategory(category)) {
                return;
            }
            Position[] positions = this.fDocument.getPositions(category);
            int i = positions.length - 1;
            while (i >= 0) {
                Position position = positions[i];
                if (position.getOffset() >= start && position.getOffset() < end) {
                    this.fDocument.removePosition(category, position);
                }
                --i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

