/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.ui.buildconfig.editor.BCCodeScanner;
import ro.amiq.dvt.ui.buildconfig.editor.BCCommentScanner;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditor;
import ro.amiq.dvt.ui.buildconfig.editor.BCNonRuleBasedDamagerRepairer;
import ro.amiq.dvt.ui.buildconfig.editor.BCPartitionScanner;
import ro.amiq.dvt.ui.buildconfig.editor.BCReconciler;
import ro.amiq.dvt.ui.buildconfig.editor.BCSourceViewerConfigurationCommon;
import ro.amiq.dvt.ui.buildconfig.editor.BCStyle;
import ro.amiq.dvt.ui.buildconfig.editor.contentassist.BCContentAssistProcessorManager;
import ro.amiq.dvt.ui.buildconfig.editor.hover.BCAnnotationHover;
import ro.amiq.dvt.ui.buildconfig.editor.hover.BCTextHover;
import ro.amiq.dvt.ui.editor.BuildConfigHyperlinkDetector;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.quickfix.BCEditorQuickFixProcessor;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixConstants;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.spelling.WordQuickFixProcessor;

public class BCSourceViewerConfiguration
extends BCSourceViewerConfigurationCommon {
    private BCEditor fEditor;
    private DVTPresentationReconciler fPresentationReconciler;
    private ITextHover fTextHover;
    private IAnnotationHover fAnnotationHover;
    private BCCommentScanner fCommentScanner;
    protected String[] fConfiguredContentType = new String[]{"__dftl_partition_content_type", "__BC_literal", "__BC_sl_comment", "__BC_ml_comment"};
    private FastPartitioner partitioner;

    public BCSourceViewerConfiguration(BCEditor editor) {
        super(DVTPlugin.getDefault().getCombinedPreferenceStore());
        this.fEditor = editor;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__BC_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.fConfiguredContentType;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fEditor == null) {
            return null;
        }
        if (this.fTextHover == null) {
            this.fTextHover = new BCTextHover((ITextEditor)this.fEditor);
        }
        return this.fTextHover;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new BCAnnotationHover((ITextEditor)this.fEditor);
        }
        return this.fAnnotationHover;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        final WordQuickFixProcessor spellingQuickFix = new WordQuickFixProcessor((ITextEditor)this.fEditor);
        IQuickAssistProcessor processor = new IQuickAssistProcessor(){

            public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
                return false;
            }

            public boolean canFix(Annotation annotation) {
                if (annotation == null) {
                    return false;
                }
                String annotationType = annotation.getType();
                boolean spellingAssist = "org.eclipse.ui.workbench.texteditor.spelling".equals(annotationType);
                if (spellingAssist) {
                    return true;
                }
                if (annotation instanceof MarkerAnnotation) {
                    int quickFixKind;
                    block10: {
                        IMarker marker;
                        block9: {
                            marker = ((MarkerAnnotation)annotation).getMarker();
                            try {
                                if (DVTProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) break block9;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        String elementName = marker.getAttribute("QUICKFIX_ELEMENT_NAME", "");
                        int scopeOffset = marker.getAttribute("charStart", -1);
                        if (scopeOffset == -1) {
                            int line = marker.getAttribute("lineNumber", 1);
                            scopeOffset = BCSourceViewerConfiguration.this.fEditor.getDocument().getLineOffset(line - 1);
                        }
                        quickFixKind = marker.getAttribute("QUICKFIX_KIND", -1);
                        if (elementName != null && scopeOffset != -1 && quickFixKind != -1) break block10;
                        return false;
                    }
                    if (QuickFixConstants.IMPLEMENTED_QUICK_FIXES.contains(quickFixKind)) {
                        return true;
                    }
                }
                return false;
            }

            public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
                ICompletionProposal[] result = new BCEditorQuickFixProcessor((ITextEditor)BCSourceViewerConfiguration.this.fEditor).computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                result = spellingQuickFix.computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                return new ICompletionProposal[]{DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE};
            }

            public String getErrorMessage() {
                return null;
            }
        };
        assistant.setQuickAssistProcessor(processor);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.setStatusLineVisible(true);
        assistant.setStatusMessage("Build config directives");
        BCContentAssistProcessorManager processor = new BCContentAssistProcessorManager(this.fEditor, assistant);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public static void updatePresentationReconciler(IPresentationReconciler reconciler) {
        IToken token = BCStyle.getInstance().getToken("highlight.string");
        ((BCNonRuleBasedDamagerRepairer)((DVTPresentationReconciler)reconciler).getDamager("__BC_literal")).setToken(token);
        ((BCNonRuleBasedDamagerRepairer)((DVTPresentationReconciler)reconciler).getRepairer("__BC_literal")).setToken(token);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.fPresentationReconciler == null) {
            this.fPresentationReconciler = new DVTPresentationReconciler();
            this.fPresentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            BCReconciler dr1 = new BCReconciler((ITokenScanner)new BCCodeScanner(BCStyle.getInstance(), true), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
            IToken stringToken = BCStyle.getInstance().getToken("highlight.string");
            BCNonRuleBasedDamagerRepairer dr2 = new BCNonRuleBasedDamagerRepairer(stringToken);
            this.fPresentationReconciler.setDamager(dr2, "__BC_literal");
            this.fPresentationReconciler.setRepairer(dr2, "__BC_literal");
            BCReconciler dr3 = new BCReconciler((ITokenScanner)this.getBCCommentScanner(), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr3, "__BC_sl_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr3, "__BC_sl_comment");
            BCReconciler dr4 = new BCReconciler((ITokenScanner)this.getBCCommentScanner(), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr4, "__BC_ml_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr4, "__BC_ml_comment");
        }
        return this.fPresentationReconciler;
    }

    protected BCCommentScanner getBCCommentScanner() {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new BCCommentScanner(BCStyle.getInstance(), true);
            this.fCommentScanner.setDefaultReturnToken(BCStyle.getInstance().getToken("highlight.comment"));
        }
        return this.fCommentScanner;
    }

    @Override
    public void setupDocumentPartitioner(IDocument document) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            this.partitioner = new FastPartitioner((IPartitionTokenScanner)new BCPartitionScanner(), new String[]{"__BC_sl_comment", "__BC_ml_comment", "__BC_literal", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__BC_partitioning", (IDocumentPartitioner)this.partitioner);
            this.partitioner.connect(document);
        }
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        BCStyle.getInstance().adaptToPreferenceChange(event);
    }

    @Override
    public void dispose() {
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.setDamager(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setDamager(null, "__BC_literal");
            this.fPresentationReconciler.setRepairer(null, "__BC_literal");
            this.fPresentationReconciler.setDamager(null, "__BC_sl_comment");
            this.fPresentationReconciler.setRepairer(null, "__BC_sl_comment");
            this.fPresentationReconciler.setDamager(null, "__BC_ml_comment");
            this.fPresentationReconciler.setRepairer(null, "__BC_ml_comment");
            this.fPresentationReconciler = null;
        }
        this.fTextHover = null;
        this.fEditor = null;
        this.fAnnotationHover = null;
        if (this.fCommentScanner != null) {
            this.fCommentScanner.dispose();
            this.fCommentScanner = null;
        }
        if (this.partitioner != null) {
            this.partitioner.disconnect();
        }
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        detectors[0] = new BuildConfigHyperlinkDetector();
        if (inheritedDetectors != null) {
            int i = 0;
            while (i < inheritedDetectorsLength) {
                detectors[i + 1] = inheritedDetectors[i];
                ++i;
            }
        }
        return detectors;
    }

    @Override
    public DVTEditor getEditor() {
        return this.fEditor;
    }

    @Override
    public void detectIndentation() {
    }

    @Override
    public void detectIndentation(IDocument document) {
    }

    @Override
    public void refreshTabWidth(int tabWidth) {
        this.setTabWidth(tabWidth);
    }

    @Override
    public void refreshInsertSpaces(boolean insertSpaces) {
        this.setInsertSpaces(insertSpaces);
    }
}

