/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class BCStyle {
    private static HashMap<String, Token> fTokenMap = new HashMap();
    private HighlightPreferenceListener fPreferenceListener = new HighlightPreferenceListener();
    private IPreferenceStore fStore = DVTPlugin.getDefault().getPreferenceStore();
    private static volatile BCStyle fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BCStyle getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new BCStyle();
            }
        }
        return fInstance;
    }

    private BCStyle() {
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void dispose() {
        fTokenMap = null;
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fPreferenceListener = null;
    }

    public IToken getToken(String key) {
        Token res = fTokenMap.get(key);
        if (res != null) {
            return res;
        }
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        res = new Token((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(key) + ".color"))), null, (store.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (store.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        fTokenMap.put(key, res);
        return res;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        String pp = p.replaceFirst(".((color)|(bold)|(italic))", "");
        if (p.endsWith(".color")) {
            this.adaptColorChange(fTokenMap.get(pp), event);
        } else if (p.endsWith(".bold")) {
            this.adaptToStyleChange(fTokenMap.get(pp), event, 1);
        } else if (p.endsWith(".italic")) {
            this.adaptToStyleChange(fTokenMap.get(pp), event, 2);
        }
    }

    private void adaptColorChange(Token token, PropertyChangeEvent event) {
        Object data;
        if (token == null) {
            return;
        }
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null && (data = token.getData()) instanceof TextAttribute) {
            TextAttribute oldAttr = (TextAttribute)data;
            token.setData((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(rgb), oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    private class HighlightPreferenceListener
    implements IPropertyChangeListener {
        private HighlightPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getProperty().startsWith("highlight")) {
                return;
            }
            BCStyle.this.adaptToPreferenceChange(event);
        }
    }
}

