/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTWordFinder;

public class BCWordFinder
extends DVTWordFinder {
    private static BCWordFinder fBCWordFinder;

    public static BCWordFinder getDefault() {
        if (fBCWordFinder == null) {
            fBCWordFinder = new BCWordFinder();
        }
        return fBCWordFinder;
    }

    @Override
    public IRegion getWordAtOffset(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new Region(0, 0);
            }
            char ch = document.getChar(Math.max(0, pos - 1));
            if (!Character.isJavaIdentifierPart(ch)) {
                return new Region(0, 0);
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            while (pos >= 0) {
                ch = (char)scanner.read();
                if (!Character.isJavaIdentifierPart(ch)) break;
                --pos;
            }
            ch = document.getChar(pos);
            if (!Character.isJavaIdentifierStart(ch)) {
                return new Region(0, 0);
            }
            start = pos;
            pos = offset;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            while (ch != '\uffff') {
                ch = (char)scanner.read();
                if (!Character.isJavaIdentifierPart(ch)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            return new Region(start, end - start);
        }
        return new Region(0, 0);
    }

    @Override
    public IRegion getWordAtOffset(IDocument document, int offset, boolean enableNumerics) {
        return this.getWordAtOffset(document, offset);
    }
}

